! $Id$
MODULE lmdz_call_cloud_optics_prop

CONTAINS

  SUBROUTINE call_cloud_optics_prop(klon, klev, ok_newmicro,&
       paprs, pplay, temp, radocond, picefra, pclc, &
    pcltau, pclemi, pch, pcl, pcm, pct, radocondwp, xflwp, xfiwp, xflwc, xfiwc, ok_aie, &
    mass_solu_aero, mass_solu_aero_pi, pcldtaupi, distcltop, temp_cltop, re, fl, reliq, reice, &
    reliq_pi, reice_pi, scdnc, cldncl, reffclwtop, lcc, reffclws, &
    reffclwc, cldnvi, lcc3d, lcc3dcon, lcc3dstra, icc3dcon, icc3dstra,  & 
    icefrac_optics, dNovrN, ptconv,rnebcon, ccwcon, &
    !--AB contrails
    lincontfra, circontfra, qice_lincont, qice_circont, pclc_nocont, &
    pcltau_nocont, pclemi_nocont, pcltau_cont, pclemi_cont, pch_nocont, pct_cont, &
    xfiwp_nocont, xfiwc_nocont, reice_nocont)

  ! Interface between the LMDZ physics monitor and the cloud properties calculation routines
  ! 2023/10/02: L. Raillard, M. Coulon--Decorzens, A. Idelkadi, L. Fairhead
  ! (E. Vignon and J.-B. Madeleine in spirit)
  ! List of arguments
  !------------------

  USE lmdz_cloud_optics_prop_ini , ONLY : ok_cdnc
  USE lmdz_cloud_optics_prop_ini , ONLY : bl95_b0, bl95_b1
  USE lmdz_cloud_optics_prop_ini , ONLY : iflag_ice_thermo, ok_new_lscp, iflag_t_glace
  USE lmdz_cloud_optics_prop, ONLY : cloud_optics_prop
  
  USE icefrac_lsc_mod ! computes ice fraction (JBM 3/14)  
  USE lmdz_lscp_tools, only: icefrac_lscp

  IMPLICIT NONE
  
  ! input:
  INTEGER, INTENT(IN) :: klon, klev      ! number of horizontal and vertical grid points
  REAL, INTENT(IN) :: paprs(klon, klev+1)! pressure at bottom interfaces [Pa]
  REAL, INTENT(IN) :: pplay(klon, klev)  ! pressure at the middle of layers [Pa]
  REAL, INTENT(IN) :: temp(klon, klev)   ! temperature [K]
  REAL, INTENT(IN) :: radocond(klon, klev) ! cloud condensed water seen by radiation [kg/kg]
  REAL, INTENT(IN) :: picefra(klon,klev) ! ice fraction in clouds from large scale condensation scheme [-]
  REAL, INTENT(IN) :: rnebcon(klon,klev) ! convection cloud fraction [-]
  REAL, INTENT(IN) :: ccwcon(klon,klev)  ! condensed water from deep convection [kg/kg]
  ! jq for the aerosol indirect effect
  ! jq introduced by Johannes Quaas (quaas@lmd.jussieu.fr), 27/11/2003
  REAL, INTENT(IN) :: mass_solu_aero(klon, klev)    ! total mass concentration for all soluble aerosols [ug m-3]
  REAL, INTENT(IN) :: mass_solu_aero_pi(klon, klev) ! - (pre-industrial value)
  REAL, INTENT(IN)  :: dNovrN(klon)         ! enhancement factor for cdnc
  REAL, INTENT(OUT) :: distcltop(klon,klev) ! distance from large scale cloud top [m]
  REAL, INTENT(OUT) :: temp_cltop(klon,klev)!temperature at large scale cloud top [K]

  LOGICAL, INTENT(IN) :: ptconv(klon, klev) ! flag for grid points affected by deep convection
  LOGICAL, INTENT(IN) :: ok_newmicro, ok_aie

  ! inout:
  REAL, INTENT(INOUT) :: pclc(klon, klev) ! cloud fraction for radiation [-]

  ! out:
  REAL, INTENT(OUT) :: pct(klon)      ! 2D total cloud cover [-]
  REAL, INTENT(OUT) :: pcl(klon)      ! 2D low cloud cover [-]
  REAL, INTENT(OUT) :: pcm(klon)      ! 2D mid cloud cover [-]
  REAL, INTENT(OUT) :: pch(klon)      ! 2D high cloud cover [-]
  REAL, INTENT(OUT) :: radocondwp(klon) ! total condensed water path (seen by radiation) [kg/m2]
  REAL, INTENT(OUT) :: xflwp(klon)    ! liquid water path (seen by radiation) [kg/m2]
  REAL, INTENT(OUT) :: xfiwp(klon)    ! ice water path (seen by radiation) [kg/m2]
  REAL, INTENT(OUT) :: xflwc(klon, klev) ! liquid water content seen by radiation [kg/kg]
  REAL, INTENT(OUT) :: xfiwc(klon, klev) ! ice water content seen by radiation [kg/kg]
  REAL, INTENT(OUT) :: re(klon, klev) ! cloud droplet effective radius multiplied by fl
  REAL, INTENT(OUT) :: fl(klon, klev) ! xliq * rneb, denominator to re; fraction of liquid water clouds
                                      ! introduced to avoid problems in the averaging of the output
                                      ! water clouds within a grid cell

  REAL, INTENT(OUT) :: pcltau(klon, klev) ! cloud optical depth [m]
  REAL, INTENT(OUT) :: pclemi(klon, klev) ! cloud emissivity [-]
  REAL, INTENT(OUT) :: pcldtaupi(klon, klev) ! pre-industrial value of cloud optical thickness, ie.
                                             ! values of optical thickness that does not account
                                             ! for aerosol effects on cloud droplet radius [m]

  REAL, INTENT(OUT) :: reliq(klon, klev)   ! liquid droplet effective radius [m] 
  REAL, INTENT(OUT) :: reice(klon, klev)   ! ice effective radius [m]
  REAL, INTENT(OUT) :: reliq_pi(klon, klev)! liquid droplet effective radius [m], pre-industrial
  REAL, INTENT(OUT) :: reice_pi(klon, klev)! ice effective radius [m], pre-industrial
  REAL, INTENT(OUT) :: scdnc(klon, klev)   ! cloud droplet number concentration, mean over the whole mesh [m-3]
  REAL, INTENT(OUT) :: cldncl(klon)        ! cloud droplet number concentration at top of cloud [m-3]
  REAL, INTENT(OUT) :: reffclwtop(klon)    ! effective radius of cloud droplet at top of cloud [m] 
  REAL, INTENT(OUT) :: lcc(klon)           ! liquid Cloud Content at top of cloud [kg/kg]
  REAL, INTENT(OUT) :: reffclws(klon, klev)! stratiform cloud droplet effective radius 
  REAL, INTENT(OUT) :: reffclwc(klon, klev)! convective cloud droplet effective radius 
  REAL, INTENT(OUT) :: cldnvi(klon)        ! column Integrated cloud droplet Number [/m2]
  REAL, INTENT(OUT) :: lcc3d(klon, klev)   ! cloud fraction for liquid part only [-]
  REAL, INTENT(OUT) :: lcc3dcon(klon, klev)! cloud fraction for liquid part only, convective clouds [-]
  REAL, INTENT(OUT) :: lcc3dstra(klon, klev)!cloud fraction for liquid part only, stratiform clouds [-]
  REAL, INTENT(OUT) :: icc3dcon(klon, klev)! cloud fraction for liquid part only, convective clouds [-]
  REAL, INTENT(OUT) :: icc3dstra(klon, klev)! cloud fraction for ice part only, stratiform clouds [-] 
  REAL, INTENT(INOUT) :: icefrac_optics(klon, klev)! ice fraction in clouds seen by radiation [-]

  !--AB for contrails. All these are used / outputed only if ok_plane_contrail=y
  REAL, INTENT(IN)  :: lincontfra(klon, klev)    ! linear contrails fraction [-]
  REAL, INTENT(IN)  :: circontfra(klon, klev)    ! contrail induced cirrus fraction [-]
  REAL, INTENT(IN)  :: qice_lincont(klon, klev)  ! linear contrails condensed water [kg/kg]
  REAL, INTENT(IN)  :: qice_circont(klon, klev)  ! contrail induced cirrus condensed water [kg/kg]
  REAL, INTENT(OUT) :: pch_nocont(klon)          ! 2D high cloud cover without contrails[-]
  REAL, INTENT(OUT) :: pct_cont(klon)            ! 2D total contrails cover[-]
  REAL, INTENT(OUT) :: xfiwp_nocont(klon)        ! ice water path (seen by radiation) without contrails [kg/m2]
  REAL, INTENT(OUT) :: xfiwc_nocont(klon, klev)  ! ice water content seen by radiation without contrails [kg/kg]
  REAL, INTENT(OUT) :: pclc_nocont(klon, klev)   ! cloud fraction for radiation without contrails [-]
  REAL, INTENT(OUT) :: pcltau_nocont(klon, klev) ! cloud optical depth without contrails [-]
  REAL, INTENT(OUT) :: pclemi_nocont(klon, klev) ! cloud emissivity without contrails [-]
  REAL, INTENT(OUT) :: pcltau_cont(klon, klev)   ! contrails optical depth [-]
  REAL, INTENT(OUT) :: pclemi_cont(klon, klev)   ! contrails emissivity [-]
  REAL, INTENT(OUT) :: reice_nocont(klon, klev)  ! ice effective radius without contrails [micronts]
  !--AB

  ! Local variables
  !----------------
  INTEGER :: k
  REAL :: dzfice(klon, klev)

  IF (iflag_t_glace .EQ. 0) THEN
     icefrac_optics(:, :) = 0.
  ELSE
     DO k = 1, klev
        IF (ok_new_lscp) THEN
          CALL icefrac_lscp(klon,temp(:,k),iflag_ice_thermo,distcltop(:,k),temp_cltop(:,k), &
   &         icefrac_optics(:,k),dzfice(:,k))
        ELSE
          CALL icefrac_lsc(klon,temp(:,k),pplay(1:klon,k)/paprs(1:klon,1),icefrac_optics(:,k))
        ENDIF
     ENDDO
  ENDIF
  


  IF (ok_newmicro) THEN       
    CALL cloud_optics_prop(klon, klev, paprs, pplay, temp, radocond, picefra, pclc, &
    pcltau, pclemi, pch, pcl, pcm, pct, radocondwp, xflwp, xfiwp, xflwc, xfiwc, &
    mass_solu_aero, mass_solu_aero_pi, pcldtaupi, distcltop, temp_cltop, re, fl, reliq, reice, &
    reliq_pi, reice_pi, scdnc, cldncl, reffclwtop, lcc, reffclws, &
    reffclwc, cldnvi, lcc3d, lcc3dcon, lcc3dstra, icc3dcon, icc3dstra,  & 
    icefrac_optics, dNovrN, ptconv,rnebcon, ccwcon, &
    !--AB for contrails
    lincontfra, circontfra, qice_lincont, qice_circont, pclc_nocont, pcltau_nocont, &
    pclemi_nocont, pcltau_cont, pclemi_cont, pch_nocont, pct_cont, &
    xfiwp_nocont, xfiwc_nocont, reice_nocont)
  ELSE
    CALL nuage (paprs, pplay, &
               temp, radocond, picefra, pclc, pcltau, pclemi, &
               pch, pcl,pcm, pct, radocondwp, &
               ok_aie, &
               mass_solu_aero, mass_solu_aero_pi, &
               bl95_b0, bl95_b1, distcltop, temp_cltop, &
               pcldtaupi, re, fl)
  ENDIF
  RETURN

END SUBROUTINE call_cloud_optics_prop

END MODULE lmdz_call_cloud_optics_prop
