SUBROUTINE pre_initialize_external_physics
  USE interface_icosa_lmdz_mod, ONLY: pre_initialize_physics
  IMPLICIT NONE
  
    CALL pre_initialize_physics  

END SUBROUTINE pre_initialize_external_physics

SUBROUTINE initialize_external_physics
  USE interface_icosa_lmdz_mod, ONLY: initialize_physics
  IMPLICIT NONE
  
    CALL initialize_physics  

END SUBROUTINE initialize_external_physics


SUBROUTINE external_physics
  USE interface_icosa_lmdz_mod, ONLY: physics
  IMPLICIT NONE
  
  CALL physics

END SUBROUTINE external_physics

SUBROUTINE initialize_third_party_coupler( comp_id, comm_icosa, ierr )
 USE icolmdz_oasis
 IMPLICIT NONE
 CHARACTER(len=*), INTENT(IN) :: comp_id
 INTEGER, INTENT(OUT) :: comm_icosa
 INTEGER, INTENT(OUT) :: ierr

 INTEGER :: ncomp_id
 CALL oasis_init_comp ( ncomp_id, comp_id, ierr )
 CALL oasis_get_localcomm ( comm_icosa, ierr )

END SUBROUTINE initialize_third_party_coupler


SUBROUTINE finalize_third_party_coupler( ierr )
 USE icolmdz_oasis
 IMPLICIT NONE
 INTEGER, INTENT(OUT) :: ierr

 PRINT*, "FINALIZING THROUGH WRAPPER"
 CALL oasis_terminate( ierr )

END SUBROUTINE finalize_third_party_coupler
