#!/bin/bash

#set -vx
local_d=$PWD

if [ ! -f lmdz_env.sh ] ; then echo This script requires lmdz_env.sh script for configuration ; exit 1 ; fi
# . lmdz_env.sh $local_d
. lmdz_env.sh

sim=$1
MAINDIR=`basename \`pwd\``
PRE=FH$MAINDIR
echo $PRE
STORED=$root_dir
WORKD=$SIMRUNBASEDIR
POST=$SIMRUNBASEDIR/$MAINDIR/POST/$sim
OUT_D=$WORKD/$MAINDIR/$sim/Analyse

se=1
cosp=0
da=0
cmor=1

liste_suf=""
if [ $se = 1 ] ; then liste_suf="$liste_suf mth" ; fi
if [ $cosp = 1 ] ; then liste_suf="$liste_suf mthCOSP" ; fi
if [ $da = 1 ] ; then liste_suf="$liste_suf day" ; fi

if [ ! -d $sim ] ; then echo la simulation $sim n existe pas ; exit ; fi


yri=2001
yrf=2004

yr=$yri

cd $sim
pwd
#mkdir -p Analyse/SE Analyse/TS_DA
listemth=""
listecosp=""
listeday=""
while [ $yr -le $yrf ] ; do
  for suf in $liste_suf ; do
       echo Utilisation de hist$suf.${yr}.nc
       if [ ! -f hist$suf.${yr}.nc ] ; then
          if [ ! -f "hist$suf.${yr}01.nc" -o ! -f "hist$suf.${yr}12.nc" ] ; then echo fichiers hist$suf.${yr}01.nc -f hist$suf.${yr}12.nc manquants ; exit ; fi
          echo cdo mergetime hist$suf.${yr}??.nc hist$suf.${yr}.nc
          cdo mergetime hist$suf.${yr}??.nc hist$suf.${yr}.nc
       fi
  done
  listemth="$listemth `ls histmth.${yr}.nc`"
  listecosp="$listecosp `ls histmthCOSP.${yr}.nc`"
  listeday="$listeday `ls histday.${yr}.nc`"
  (( yr = $yr + 1 ))
done

# liste des variables reconstruite a partir de 
# grep calias ~fabric/LMDZ/atlas/lmdz_SE.py | cut -d\' -f6 | sort | uniq | sed -e '/psl/d'

varse="pourc_ter,pourc_oce,pourc_lic,pourc_sic,bils,cldt,flat,LWdnSFC,LWdnSFCclr,LWupSFC,ovap,precip,q2m,rh2m,rhum,sens,slp,SWdnSFC,SWdnSFCclr,SWdnTOA,SWupSFC,SWupSFCclr,SWupTOA,SWupTOAclr,t2m,taux_oce,tauy_oce,temp,topl,topl0,tsol,tsol_oce,vitu,vitv,vitw,wind10m,z500,snow,pr_lsc_i,pr_lsc_l,geop,phis,prw,cldl,cldm,cldh,cldt,w500,tops,tops0,sols,sols0,soll,soll0"
varse="pourc_ter,pourc_oce,pourc_lic,pourc_sic,bils,cldt,flat,LWdnSFC,LWdnSFCclr,LWupSFC,ovap,precip,q2m,rh2m,rhum,sens,slp,SWdnSFC,SWdnSFCclr,SWdnTOA,SWupSFC,SWupSFCclr,SWupTOA,SWupTOAclr,t2m,temp,topl,topl0,tsol,vitu,vitv,vitw,wind10m,snow,pr_lsc_i,pr_lsc_l,geop,phis,prw,cldl,cldm,cldh,cldt,tops,tops0,sols,sols0,soll,soll0"
# variables enlevees taux_oce, tauy_oce, tsol_oce, z500

vars1d="bils cldh cldl cldm cldq cldt evap flat pluc plul precip prw psol q2m q700 sens sicf slp soll sols SWdnSFC max min t2m t700 topl tops tsol u10m u700 u850 v10m v700 w700 wind10max wind10m"


varcosp="cllcalipso,clhcalipso,clmcalipso,cltcalipso,clcalipso"

#==========================================================================
# Correction eventuelle pour des versions definissant mal le calendrier
# 360d au lieu de 360_day. Corrige en avril 2017
listetout=""
if [ $se = 1 ] ; then listetout="$listetout $listemth" ; fi
if [ $da = 1 ] ; then listetout="$listetout $listeday" ; fi
if [ 1 = 0 ] ; then
for file in $listetout ; do
   cal=`ncdump -h $file | grep time_counter | grep calendar | cut -d\" -f2`
   if [ "$cal"  = "360d" ] ; then
      echo Correction axe des temps $file
      ncatted -a calendar,"time_counter",o,c,"360_day" -O $file
   else
   echo $file correct
  fi
done
fi
#==========================================================================


mkdir -p $POST
echo Running seasonal.sh on $POST
cd $POST

echo BIBBBBBB
cat <<eod>| post_$sim
#!/bin/bash
#SBATCH --job-name=se_$sim
#SBATCH -A gzi@cpu
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --time=01:00:00            # Temps dâ€™exÃ©cution maximum demandÃ© (HH:MM:SS)
#SBATCH --output=se_$sim%j     # Nom du fichier de sortie
#SBATCH --error=se_$sim%j   

. $local_d/lmdz_env.sh

cd $POST
ulimit -s unlimited
MAINDIR=$MAINDIR
OUT_D=$OUT_D
sim=$sim

mkdir -p $OUT_D/SE $OUT_D/TS_DA

if [ $se = 1 ] ; then
   for mth in $listemth ; do
      ln -s $STORED/$sim/\$mth
   done
   ncrcat -v $varse $listemth -O tmp.nc
   out=$PRE${sim}_SE_${yri}_${yrf}_1M_histmth.nc
   if [ ! -f \$out ] ; then
       cdo ymonmean tmp.nc \$out
   fi
   if [ $cmor = 1 ] ; then
       for var in $( echo $varse | sed -e 's/,/ /g' ) ; do
          ncks -v \$var \$out -O $OUT_D/SE/\$var.nc
       done
   else
       mv \$out $OUT_D/SE/\$out
   fi
fi

if [ $cosp = 1 ] ; then
   for cosp in $listecosp ; do
      ln -s $STORED/$sim/\$cosp
   done
   ncrcat -v $varcosp $listecosp -O tmp.nc
   out=$PRE${sim}_SE_${yri}_${yrf}_1M_histmthCOSP.nc
   if [ ! -f \$out ] ; then
       cdo ymonmean tmp.nc \$out
       mv \$out $OUT_D/SE/\$out
   fi
fi


if [ $da = 1 ] ; then
for day in $listeday ; do
   if [ ! -f \$day ] ; then ln -s $STORED/$sim/\$day ; fi
done
for var in $vars1d ; do
  out=$PRE${sim}_${yri}0101_${yrf}1231_1D_\$var.nc
  if [ ! -f \$out ] ; then
     echo ncrcat -v \$var $listeday \$out
     ncrcat -v \$var $listeday \$out
     mv \$out $OUT_D/TS_DA/\$out
   fi
done
fi
eod


submitcmd post_$sim
