MODULE lmdz_surf_wind_ini
IMPLICIT NONE 
save

  ! ============================================================================
  ! Declaration de variables
  ! -------------------------------------------------------------------------

   integer, protected :: lunout
   integer, protected :: iflag_surf_wind=0
   !$OMP THREADPRIVATE(lunout,iflag_surf_wind,nsrfwnd)

CONTAINS

  ! =========================================================================
  SUBROUTINE surf_wind_ini(klon,lunout_i)
  ! =========================================================================

  ! **************************************************************
  ! *
  ! WAKE                                                        *
  ! retour a un Pupper fixe                                *
  ! *
  ! written by   :  GRANDPEIX Jean-Yves   09/03/2000            *
  ! modified by :   ROEHRIG Romain        01/29/2007            *
  ! **************************************************************

  ! -------------------------------------------------------------------------
  ! Initialisations
  ! -------------------------------------------------------------------------


  USE ioipsl_getin_p_mod, ONLY : getin_p
  integer, intent(in) :: klon,lunout_i

  lunout=lunout_i
  CALL getin_p('iflag_surf_wind',iflag_surf_wind)

  write(lunout,*) 'Initialisation wind10m'
  write(lunout,*) 'lmdz_surf_wind_ini, iflag_surf_wind=',iflag_surf_wind

 RETURN

END SUBROUTINE surf_wind_ini



END MODULE lmdz_surf_wind_ini
