#!/bin/bash

. ./lmdz_env.sh

ulimit -s unlimited

year=$1
echo "Dans interp_aerosols.sh year= $year"

# Extraction d'un fichier de grille physique a partir de grilles_gcm.nc
# ---------------------------------------------------------------------

\rm -rf tmp*nc
if [[ 0 = 0 ]]; then
  imp1=$(ncdump -h grilles_gcm.nc | grep lonv | head -1 | awk ' { print $3 } ')
  echo "$imp1"
  (( imm1 = imp1 - 2 ))
  echo "$imm1"
  ncks -d "lonv,0,$imm1" grilles_gcm.nc -v phis -O grille_phys.nc
  ncrename -v lonv,lon -v latu,lat -d lonv,lon -d latu,lat -O grille_phys.nc
  ncap2 -s "lon=-360.+lon" grille_phys.nc -O tmp.nc
  \mv -f tmp.nc grille_phys.nc
  #exit 1
fi

# Recuperation des fichiers d'origine
# -----------------------------------

orig=aerosols${year}_from_inca.nc
ln -s $LMDZ_INIT/3DInputData/AerChem/$orig .


# Interpolation horizontale sur la grille cible
# ----------------------------------------------

# Un cdo direct ne marche pas. Il faut donner la liste des variables ...
vars=""
for var in $(ncdump -h "$orig" | grep float | sed -e 's/^.*.float //' | cut -d'(' -f1 | sed -e 's/;//' -e /lat/d -e /lon/d); do
  vars="$vars,$var"
done

echo cdo remapcon,grille_phys.nc "-selvar$vars" "$orig" tmp.nc
cdo remapcon,grille_phys.nc "-selvar$vars" "$orig" tmp.nc
#ncks -v ps,ap,b,presnivs $orig -A tmp.nc
nccopy -k classic tmp.nc "aerosols.$year.nc"
