! cosp SUBROUTINE wrappers

SUBROUTINE lmdz_cosp_wrapper_abort
  STOP 'COSP/COSP2/COSPV2 key undefined, must not enter in COSP wrappers ==> aborting'
END SUBROUTINE lmdz_cosp_wrapper_abort

#ifndef COSP

SUBROUTINE phys_cosp(itap, dtime, freq_cosp, &
        ok_mensuelCOSP, ok_journeCOSP, ok_hfCOSP, &
        ecrit_mth, ecrit_day, ecrit_hf, ok_all_xml, missing_val, &
        Nptslmdz, Nlevlmdz, lon, lat, presnivs, overlaplmdz, sunlit, &
        ref_liq, ref_ice, fracTerLic, u_wind, v_wind, phis, phi, ph, p, skt, t, &
        sh, rh, tca, cca, mr_lsliq, mr_lsice, fl_lsrainI, fl_lssnowI, &
        fl_ccrainI, fl_ccsnowI, mr_ozone, dtau_s, dem_s)

  IMPLICIT NONE

  Integer :: Nptslmdz, Nlevlmdz ! Nb de points issus de physiq.F

  ! Declaration necessaires pour les sorties IOIPSL
  integer :: ii
  real :: ecrit_day, ecrit_hf, ecrit_mth, missing_val
  logical :: ok_mensuelCOSP, ok_journeCOSP, ok_hfCOSP, ok_all_xml

  integer :: overlaplmdz   !  overlap type: 1=max, 2=rand, 3=max/rand ! cosp input (output lmdz)
  real, dimension(Nptslmdz, Nlevlmdz) :: height, phi, p, ph, T, sh, rh, tca, cca, mr_lsliq, mr_lsice, mr_ccliq, mr_ccice, &
          fl_lsrain, fl_lssnow, fl_ccrain, fl_ccsnow, fl_lsgrpl, &
          zlev, zlev_half, mr_ozone, radliq, radice, dtau_s, dem_s, ref_liq, ref_ice
  real, dimension(Nptslmdz, Nlevlmdz) :: fl_lsrainI, fl_lssnowI, fl_ccrainI, fl_ccsnowI
  real, dimension(Nptslmdz) :: lon, lat, skt, fracTerLic, u_wind, v_wind, phis, sunlit
  real, dimension(Nlevlmdz) :: presnivs
  integer :: itap, k, ip
  real :: dtime, freq_cosp
  real, dimension(2) :: time_bnds

  double precision :: d_dtime
  double precision, dimension(2) :: d_time_bnds

  CALL lmdz_cosp_wrapper_abort

END SUBROUTINE phys_cosp

#endif

#ifndef COSP2

subroutine phys_cosp2( itap,dtime,freq_cosp, ok_mensuelCOSP, ok_journeCOSP,   &
                         ok_hfCOSP, ecrit_mth, ecrit_day, ecrit_hf, ok_all_xml,   &
                         missing_val, Nptslmdz, Nlevlmdz, lon, lat, presnivs,     &
                         overlaplmdz, sunlit, ref_liq, ref_ice, fracTerLic,       &
                         u_wind, v_wind, phis, phi, ph, p, skt, t, sh, rh,        &
                         tca, cca, mr_lsliq, mr_lsice, fl_lsrainI, fl_lssnowI,    &
                         fl_ccrainI, fl_ccsnowI, mr_ozone, dtau_s, dem_s)

  IMPLICIT NONE

!-----------------------------  Input variables from LMDZ-GCM  -------------------------------
  integer                             	     :: overlaplmdz   ! overlap type: 1=max,
  					       		      ! 2=rand, 3=max/rand
  logical :: ok_mensuelcosp, ok_journecosp, ok_hfcosp, ok_all_xml
  real :: ecrit_mth, ecrit_day, ecrit_hf, missing_val
  integer :: nptslmdz, nlevlmdz
  real, dimension(Nptslmdz,Nlevlmdz) 	     :: phi, p, ph, T, sh, rh, tca, cca, mr_lsliq,   &
  					        mr_lsice, mr_ccliq, mr_ccice, fl_lsrain,     &
                                       	        fl_lssnow, fl_ccrain, fl_ccsnow, fl_lsgrpl,  &
                                       	        zlev, zlev_half, mr_ozone, radliq, radice,   &
					        dtau_s, dem_s, dtau_c, dem_c, ref_liq, ref_ice
  real, dimension(Nptslmdz,Nlevlmdz) 	     :: fl_lsrainI, fl_lssnowI, fl_ccrainI, fl_ccsnowI
  real, dimension(Nptslmdz)        	     :: lon, lat, skt, fracTerLic, u_wind, v_wind, &
  					        phis, sunlit
  real, dimension(Nptslmdz)        	     :: land ! variables intermediaire pour masque TerLic
  real, dimension(Nlevlmdz)        	     :: presnivs
  integer                         	     :: itap, k, ip
  real                            	     :: dtime, freq_cosp
  real, dimension(2)               	     :: time_bnds

  double precision                           :: d_dtime
  double precision, dimension(2)             :: d_time_bnds

  CALL lmdz_cosp_wrapper_abort

end subroutine phys_cosp2

#endif
