! ---------------------------------------------
! This file is part of an effort to replace most uses of preprocessor CPP keys by fortran variables,
! to improve readability, compilation coverage, and linting.
! CPP keys used here should ONLY be used here (unless specified explicitely),
! and imported through USE ..., ONLY: ... elsewhere
! CPP keys supported (key -> fortran variables associated):
!      NC_DOUBLE      -> nf90_format
!      CPP_PHYS       -> CPPKEY_PHYS
!      INCA           -> CPPKEY_INCA   ! -> also in lmdz_inca_wrappers.F90
!      REPROBUS       -> CPPKEY_REPROBUS  ! -> also in lmdz_reprobus_wrappers.F90
!      CPP_StratAer   -> CPPKEY_STRATAER
!      CPP_DUST       -> CPPKEY_DUST  ! only used in PHYS
!      CPP_INLANDSIS  -> CPPKEY_INLANDSIS  ! only used in PHYS
!      OUTPUT_PHYS_SCM-> CPPKEY_OUTPUTPHYSSCM ! only used in DYN1D
!      CPP_COSP       -> CPPKEY_COSP  ! only used in PHYS
!      CPP_COSP2      -> CPPKEY_COSP2  ! only used in PHYS
!      CPP_COSPV2     -> CPPKEY_COSPV2  ! only used in PHYS
!
! NB Laurent 09/24: Certaines clés sont utilisées uniquement dans la physique, mais on décide de les laisser dans misc/ pour l'instant.
! ---------------------------------------------

MODULE lmdz_cppkeys_wrapper
  USE, INTRINSIC :: ISO_FORTRAN_ENV, ONLY: REAL64, REAL32
  USE netcdf, ONLY: nf90_float, nf90_double
  IMPLICIT NONE; PRIVATE
  PUBLIC nf90_format, CPPKEY_PHYS, CPPKEY_INCA, CPPKEY_STRATAER, CPPKEY_DUST, &
          CPPKEY_INLANDSIS, CPPKEY_OUTPUTPHYSSCM, CPPKEY_COSP, CPPKEY_COSP2, &
          CPPKEY_COSPV2, CPPKEY_REPROBUS

#ifdef NC_DOUBLE
  INTEGER :: nf90_format = nf90_double
#else
  INTEGER :: nf90_format = nf90_float
#endif

#ifdef CPP_PHYS
  LOGICAL :: CPPKEY_PHYS = .TRUE.
#else
  LOGICAL :: CPPKEY_PHYS = .FALSE.
#endif

#ifdef INCA
  LOGICAL :: CPPKEY_INCA = .TRUE.
#else
  LOGICAL :: CPPKEY_INCA = .FALSE.
#endif

#ifdef REPROBUS
  LOGICAL :: CPPKEY_REPROBUS = .TRUE.
#else
  LOGICAL :: CPPKEY_REPROBUS = .FALSE.
#endif

#ifdef CPP_StratAer
  LOGICAL :: CPPKEY_STRATAER = .TRUE.
#else
  LOGICAL :: CPPKEY_STRATAER = .FALSE.
#endif

#ifdef CPP_DUST
  LOGICAL :: CPPKEY_DUST = .TRUE.
#else
  LOGICAL :: CPPKEY_DUST = .FALSE.
#endif

#ifdef CPP_INLANDSIS
  LOGICAL :: CPPKEY_INLANDSIS = .TRUE.
#else
  LOGICAL :: CPPKEY_INLANDSIS = .FALSE.
#endif

#ifdef OUTPUT_PHYS_SCM
  LOGICAL :: CPPKEY_OUTPUTPHYSSCM = .TRUE.
#else
  LOGICAL :: CPPKEY_OUTPUTPHYSSCM = .FALSE.
#endif

#ifdef CPP_COSP
  LOGICAL :: CPPKEY_COSP = .TRUE.
#else
  LOGICAL :: CPPKEY_COSP = .FALSE.
#endif

#ifdef CPP_COSP2
  LOGICAL :: CPPKEY_COSP2 = .TRUE.
#else
  LOGICAL :: CPPKEY_COSP2 = .FALSE.
#endif

#ifdef CPP_COSPV2
  LOGICAL :: CPPKEY_COSPV2 = .TRUE.
#else
  LOGICAL :: CPPKEY_COSPV2 = .FALSE.
#endif

END MODULE lmdz_cppkeys_wrapper