SUBROUTINE rotat_nfil_loc (klevel, x, y, rot )
  !
  !    Auteur :   P.Le Van
  !**************************************************************
  !.          Calcule le rotationnel  non filtre   ,
  !  a tous les niveaux d'1 vecteur de comp. x et y ..
  !   x  et  y etant des composantes  covariantes  ...
  !********************************************************************
  !   klevel, x  et y   sont des arguments d'entree pour le s-prog
  !        rot          est  un argument  de sortie pour le s-prog
  !
  USE comgeom_mod_h
  USE parallel_lmdz
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h, ONLY: iip1, iip2, iip3, jjp1, llmp1, llmp2, llmm1, kftd, ip1jm, ip1jmp1, &
          ip1jmi1, ijp1llm, ijmllm, mvar, jcfil, jcfllm
IMPLICIT NONE
  !


  !
  !   .....  variables en arguments  ......
  !
  INTEGER :: klevel
  REAL :: rot( ijb_v:ije_v,klevel )
  REAL :: x( ijb_u:ije_u,klevel ), y( ijb_v:ije_v,klevel )
  !
  !  ...   variables  locales  ...
  !
  INTEGER :: l, ij
  INTEGER :: ijb,ije
  !
  !
  ijb=ij_begin
  ije=ij_end
  if(pole_sud) ije=ij_end-iip1
!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l = 1,klevel
  !
    DO   ij = ijb, ije - 1
     rot( ij,l )  =    y( ij+1 , l )  -  y( ij,l )   + &
           x(ij +iip1, l )  -  x( ij,l )
    ENDDO
  !
  !    .... correction pour rot( iip1,j,l)  ....
  !    ....   rot(iip1,j,l)= rot(1,j,l) ...
  !DIR$ IVDEP
    DO  ij = ijb+iip1-1, ije, iip1
     rot( ij,l ) = rot( ij -iim,l )
    ENDDO
  !
  END DO
!$OMP END DO NOWAIT
  RETURN
END SUBROUTINE rotat_nfil_loc
