SUBROUTINE nxgrad_gam_loc( klevel, rot, x, y )
  !
  !  P. Le Van
  !
  !   ********************************************************************
  !  calcul du gradient tourne de pi/2 du rotationnel du vect.v
  !   ********************************************************************
  !   rot          est un argument  d'entree pour le s-prog
  !   x  et y    sont des arguments de sortie pour le s-prog
  !
  USE comgeom_mod_h
  USE parallel_lmdz

  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h, ONLY: iip1, iip2, iip3, jjp1, llmp1, llmp2, llmm1, kftd, ip1jm, ip1jmp1, &
          ip1jmi1, ijp1llm, ijmllm, mvar, jcfil, jcfllm
IMPLICIT NONE
  !


  INTEGER :: klevel
  REAL :: rot( ijb_v:ije_v,klevel )
  REAL :: x( ijb_u:ije_u,klevel ),y(ijb_v:ije_v,klevel )
  INTEGER :: l,ij
  integer :: ismin,ismax
  external ismin,ismax
  INTEGER :: ijb,ije
  !
!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l = 1,klevel
  !
  ijb=ij_begin
  ije=ij_end
  if(pole_sud) ije=ij_end-iip1

  DO  ij = ijb+1, ije
  y( ij,l ) = (rot( ij,l ) - rot( ij-1,l )) * cvscuvgam( ij )
  END DO
  !
  !    ..... correction pour  y ( 1,j,l )  ......
  !
  !    ....    y(1,j,l)= y(iip1,j,l) ....
  !DIR$ IVDEP
  DO  ij = ijb, ije, iip1
  y( ij,l ) = y( ij +iim,l )
  END DO
  !
  ijb=ij_begin
  ije=ij_end+iip1
  if(pole_nord) ijb=ij_begin+iip1
  if(pole_sud) ije=ij_end-iip1

  DO  ij = ijb,ije
  x( ij,l ) = (rot( ij,l ) - rot( ij -iip1,l )) * cuscvugam( ij )
  END DO

  if (pole_nord) then
    DO  ij = 1,iip1
     x(    ij    ,l ) = 0.
    ENDDO
  endif

  if (pole_sud) then
    DO  ij = 1,iip1
     x( ij +ip1jm,l ) = 0.
    ENDDO
  endif
  !
  END DO
!$OMP END DO NOWAIT
  RETURN
END SUBROUTINE nxgrad_gam_loc
