SUBROUTINE laplacien_rotgam_loc ( klevel, rotin, rotout )
  !
  ! P. Le Van
  !
  !   ************************************************************
  !   ... calcul de  (rotat x nxgrad)_gam  du rotationnel rotin ..
  !   ************************************************************
  ! klevel et teta  sont des arguments  d'entree pour le s-prog
  !  divgra     est  un argument  de sortie pour le s-prog
  !
  USE comgeom_mod_h
  USE parallel_lmdz
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h, ONLY: iip1, iip2, iip3, jjp1, llmp1, llmp2, llmm1, kftd, ip1jm, ip1jmp1, &
          ip1jmi1, ijp1llm, ijmllm, mvar, jcfil, jcfllm
IMPLICIT NONE
  !



  !
  !    .............   variables  en  arguments    ...........
  !
  INTEGER :: klevel
  REAL :: rotin( ijb_v:ije_v,klevel ), rotout( ijb_v:ije_v,klevel )
  !
  !   ............     variables   locales     ...............
  !
  INTEGER :: l, ij
  REAL :: ghy(ijb_v:ije_v,llm), ghx(ijb_u:ije_u,llm)
  !   ........................................................
  !
  INTEGER :: ijb,ije

  !

  CALL   nxgrad_gam_loc ( klevel, rotin,   ghx ,   ghy  )
  CALL   rotat_nfil_loc ( klevel, ghx  ,   ghy , rotout )
  !
  ijb=ij_begin
  ije=ij_end
  if(pole_sud) ije=ij_end-iip1
!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l = 1, klevel
    DO ij = ijb, ije
     rotout(ij,l) = rotout(ij,l) * unsairz_gam(ij)
    ENDDO
  ENDDO
!$OMP END DO NOWAIT
  RETURN
END SUBROUTINE laplacien_rotgam_loc
