SUBROUTINE laplacien_gam_loc ( klevel, cuvsga, cvusga, unsaigam, &
        unsapolnga, unsapolsga, teta, divgra )

  !  P. Le Van
  !
  !   ************************************************************
  !
  !  ....   calcul de  (div( grad ))   de   teta  .....
  !   ************************************************************
  !    klevel et teta  sont des arguments  d'entree pour le s-prog
  !  divgra     est  un argument  de sortie pour le s-prog
  !
  USE comgeom_mod_h
  USE parallel_lmdz
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h, ONLY: iip1, iip2, iip3, jjp1, llmp1, llmp2, llmm1, kftd, ip1jm, ip1jmp1, &
          ip1jmi1, ijp1llm, ijmllm, mvar, jcfil, jcfllm
IMPLICIT NONE
  !



  !
  !    ............     variables  en arguments    ..........
  !
  INTEGER :: klevel
  REAL :: teta( ijb_u:ije_u,klevel ), divgra( ijb_u:ije_u,klevel )
  REAL :: cuvsga(ip1jm) , cvusga( ip1jmp1 )
  REAL :: unsaigam(ip1jmp1)
  REAL :: unsapolnga, unsapolsga
  !
  !    ...........    variables  locales    .................
  !
  REAL :: ghy(ijb_v:ije_v,llm), ghx(ijb_u:ije_u,llm)
  !    ......................................................

  INTEGER :: ijb,ije
  INTEGER :: l
  !
  !
  !   ...  cvuscugam  = ( cvu/ cu ) ** (- gamdissip )
  !   ...  cuvscvgam  = ( cuv/ cv ) ** (- gamdissip )  calcules dans inigeom  ..
  !   ...  unsairegam =  1. /  aire ** (- gamdissip )
  !

  !  CALL SCOPY ( ip1jmp1 * klevel, teta, 1, divgra, 1 )

  ijb=ij_begin-iip1
  ije=ij_end+iip1
  if (pole_nord) ijb=ij_begin
  if (pole_sud ) ije=ij_end

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l=1,klevel
    divgra(ijb:ije,l)=teta(ijb:ije,l)
  ENDDO
!$OMP END DO NOWAIT

  !
  CALL   grad_loc ( klevel, divgra, ghx, ghy )
  !
  CALL  diverg_gam_loc ( klevel, cuvsga, cvusga,  unsaigam  , &
        unsapolnga, unsapolsga, ghx , ghy , divgra )

  !

  RETURN
END SUBROUTINE laplacien_gam_loc
