SUBROUTINE covcont_loc (klevel,ucov, vcov, ucont, vcont )
  USE comgeom_mod_h
  USE parallel_lmdz
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
  USE paramet_mod_h, ONLY: iip1, iip2, iip3, jjp1, llmp1, llmp2, llmm1, kftd, ip1jm, ip1jmp1, &
          ip1jmi1, ijp1llm, ijmllm, mvar, jcfil, jcfllm
IMPLICIT NONE

  !=======================================================================
  !
  !   Auteur:  P. Le Van
  !   -------
  !
  !   Objet:
  !   ------
  !
  !  *********************************************************************
  !    calcul des compos. contravariantes a partir des comp.covariantes
  !  ********************************************************************
  !
  !=======================================================================

  INTEGER :: klevel
  REAL :: ucov( ijb_u:ije_u,klevel ),  vcov( ijb_v:ije_v,klevel )
  REAL :: ucont( ijb_u:ije_u,klevel ), vcont( ijb_v:ije_v,klevel )
  INTEGER :: l,ij
  INTEGER :: ijbu,ijbv,ijeu,ijev


  ijbu=ij_begin-iip1
  ijbv=ij_begin-iip1
  ijeu=ij_end+iip1
  ijev=ij_end+iip1

  if (pole_nord) then
    ijbu=ij_begin+iip1
    ijbv=ij_begin
  endif

  if (pole_sud) then
    ijeu=ij_end-iip1
    ijev=ij_end-iip1
  endif

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l = 1,klevel

  DO  ij = ijb_u,ije_u
  ucont( ij,l ) = ucov( ij,l ) * unscu2( ij )
  END DO

  DO ij = ijb_v,ije_v
  vcont( ij,l ) = vcov( ij,l ) * unscv2( ij )
  END DO

  END DO
!$OMP END DO NOWAIT
  RETURN
END SUBROUTINE covcont_loc
