SUBROUTINE convmas2_loc (convm)
!
!-------------------------------------------------------------------------------
! Authors: P. Le Van , Fr. Hourdin.
!-------------------------------------------------------------------------------
! Purpose: Compute mass flux convergence at p levels.
!          Equivalent to convmas_loc if convmas1_loc is called before.
  USE comgeom_mod_h
  USE parallel_lmdz
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h, ONLY: iip1, iip2, iip3, jjp1, llmp1, llmp2, llmm1, kftd, ip1jm, ip1jmp1, &
          ip1jmi1, ijp1llm, ijmllm, mvar, jcfil, jcfllm
IMPLICIT NONE


!===============================================================================
! Arguments:
  REAL, INTENT(INOUT) :: convm(ijb_u:ije_u,llm)
!===============================================================================
! Method used:   Computation from top to bottom.
!   Mass convergence at level llm is equal to zero and is not stored in convm.
!===============================================================================
! Local variables:
  INTEGER :: l, ijb, ije
!===============================================================================

!$OMP MASTER
!--- Mass convergence is integrated from top to bottom
  ijb=ij_begin
  ije=ij_end+iip1
  IF(pole_sud) ije=ij_end
  DO l=llmm1,1,-1
    convm(ijb:ije,l) = convm(ijb:ije,l) + convm(ijb:ije,l+1)
  END DO
!$OMP END MASTER

END SUBROUTINE convmas2_loc

