SUBROUTINE convmas1_loc (pbaru, pbarv, convm)
!
!-------------------------------------------------------------------------------
! Authors: P. Le Van , Fr. Hourdin.
!-------------------------------------------------------------------------------
! Purpose: Compute mass flux convergence at p levels.
!          Equivalent to convmas_loc if convmas2_loc is called after.
  USE comgeom_mod_h
  USE parallel_lmdz
  USE mod_filtreg_p
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h, ONLY: iip1, iip2, iip3, jjp1, llmp1, llmp2, llmm1, kftd, ip1jm, ip1jmp1, &
          ip1jmi1, ijp1llm, ijmllm, mvar, jcfil, jcfllm
IMPLICIT NONE


!===============================================================================
! Arguments:
  REAL, INTENT(IN)  :: pbaru(ijb_u:ije_u,llm)
  REAL, INTENT(IN)  :: pbarv(ijb_v:ije_v,llm)
  REAL, TARGET, INTENT(OUT) :: convm(ijb_u:ije_u,llm)
!===============================================================================
! Method used:   Computation from top to bottom.
!   Mass convergence at level llm is equal to zero and is not stored in convm.
!===============================================================================
! Local variables:
  INTEGER :: l, jjb, jje
!===============================================================================

!--- Computation of - (d(pbaru)/dx + d(pbarv)/dy )
  CALL convflu_loc( pbaru, pbarv, llm, convm )

!--- Filter
  jjb=jj_begin
  jje=jj_end+1
  IF(pole_sud) jje=jj_end
  CALL filtreg_p(convm,jjb_u,jje_u,jjb,jje,jjp1,llm,2,2,.TRUE.,1)

END SUBROUTINE convmas1_loc

