!
! $Id: limy.f90 5281 2024-10-28 10:17:48Z abarral $
!
SUBROUTINE limy(s0,sy,sm,pente_max)
  !
  ! Auteurs:   P.Le Van, F.Hourdin, F.Forget
  !
  !    ********************************************************************
  ! Shema  d'advection " pseudo amont " .
  !    ********************************************************************
  ! q,w sont des arguments d'entree  pour le s-pg ....
  ! dq 	       sont des arguments de sortie pour le s-pg ....
  !
  !
  !   --------------------------------------------------------------------
  USE comgeom_mod_h
  USE comconst_mod, ONLY: pi
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h, ONLY: iip1, iip2, iip3, jjp1, llmp1, llmp2, llmm1, kftd, ip1jm, ip1jmp1, &
          ip1jmi1, ijp1llm, ijmllm, mvar, jcfil, jcfllm
IMPLICIT NONE
  !


  !
  !
  !   Arguments:
  !   ----------
  real :: pente_max
  real :: s0(ip1jmp1,llm),sy(ip1jmp1,llm),sm(ip1jmp1,llm)
  !
  !  Local
  !   ---------
  !
  INTEGER :: i,ij,l
  !
  REAL :: q(ip1jmp1,llm)
  REAL :: airej2,airejjm,airescb(iim),airesch(iim)
  real :: sigv,dyq(ip1jmp1),dyqv(ip1jm)
  real :: adyqv(ip1jm),dyqmax(ip1jmp1)
  REAL :: qbyv(ip1jm,llm)

  REAL :: qpns,qpsn,appn,apps,dyn1,dys1,dyn2,dys2
  Logical :: extremum,first
  save first

  real :: convpn,convps,convmpn,convmps
  real :: sinlon(iip1),sinlondlon(iip1)
  real :: coslon(iip1),coslondlon(iip1)
  save sinlon,coslon,sinlondlon,coslondlon
  !
  !
  REAL :: SSUM
  integer :: ismax,ismin
  EXTERNAL  SSUM, convflu,ismin,ismax
  EXTERNAL filtreg

  data first/.true./

  if(first) then
     print*,'SCHEMA AMONT NOUVEAU'
     first=.false.
     do i=2,iip1
        coslon(i)=cos(rlonv(i))
        sinlon(i)=sin(rlonv(i))
        coslondlon(i)=coslon(i)*(rlonu(i)-rlonu(i-1))/pi
        sinlondlon(i)=sinlon(i)*(rlonu(i)-rlonu(i-1))/pi
     enddo
     coslon(1)=coslon(iip1)
     coslondlon(1)=coslondlon(iip1)
     sinlon(1)=sinlon(iip1)
     sinlondlon(1)=sinlondlon(iip1)
  endif

  !

  do l = 1, llm
  !
     DO ij=1,ip1jmp1
           q(ij,l) = s0(ij,l) / sm ( ij,l )
           dyq(ij) = sy(ij,l) / sm ( ij,l )
     ENDDO
  !
  !   --------------------------------
  !  CALCUL EN LATITUDE
  !   --------------------------------

  !   On commence par calculer la valeur du traceur moyenne sur le premier cercle
  !   de latitude autour du pole (qpns pour le pole nord et qpsn pour
  !    le pole nord) qui sera utilisee pour evaluer les pentes au pole.

  airej2 = SSUM( iim, aire(iip2), 1 )
  airejjm= SSUM( iim, aire(ip1jm -iim), 1 )
  DO i = 1, iim
  airescb(i) = aire(i+ iip1) * q(i+ iip1,l)
  airesch(i) = aire(i+ ip1jm- iip1) * q(i+ ip1jm- iip1,l)
  ENDDO
  qpns   = SSUM( iim,  airescb ,1 ) / airej2
  qpsn   = SSUM( iim,  airesch ,1 ) / airejjm

  !   calcul des pentes aux points v

  do ij=1,ip1jm
     dyqv(ij)=q(ij,l)-q(ij+iip1,l)
     adyqv(ij)=abs(dyqv(ij))
  ENDDO

  !   calcul des pentes aux points scalaires

  do ij=iip2,ip1jm
     dyqmax(ij)=min(adyqv(ij-iip1),adyqv(ij))
     dyqmax(ij)=pente_max*dyqmax(ij)
  enddo

  !   calcul des pentes aux poles

  !   calcul des pentes limites aux poles

  ! print*,dyqv(iip1+1)
  ! appn=abs(dyq(1)/dyqv(iip1+1))
  ! print*,dyq(ip1jm+1)
  ! print*,dyqv(ip1jm-iip1+1)
  ! apps=abs(dyq(ip1jm+1)/dyqv(ip1jm-iip1+1))
  ! do ij=2,iim
  !    appn=amax1(abs(dyq(ij)/dyqv(ij)),appn)
  !    apps=amax1(abs(dyq(ip1jm+ij)/dyqv(ip1jm-iip1+ij)),apps)
  ! enddo
  ! appn=min(pente_max/appn,1.)
  ! apps=min(pente_max/apps,1.)


  !   cas ou on a un extremum au pole

  ! if(dyqv(ismin(iim,dyqv,1))*dyqv(ismax(iim,dyqv,1)).le.0.)
  !    &   appn=0.
  ! if(dyqv(ismax(iim,dyqv(ip1jm-iip1+1),1)+ip1jm-iip1+1)*
  !    &   dyqv(ismin(iim,dyqv(ip1jm-iip1+1),1)+ip1jm-iip1+1).le.0.)
  !    &   apps=0.

  !   limitation des pentes aux poles
  ! do ij=1,iip1
  !    dyq(ij)=appn*dyq(ij)
  !    dyq(ip1jm+ij)=apps*dyq(ip1jm+ij)
  ! enddo

  !   test
  !  do ij=1,iip1
  !     dyq(iip1+ij)=0.
  !     dyq(ip1jm+ij-iip1)=0.
  !  enddo
  !  do ij=1,ip1jmp1
  !     dyq(ij)=dyq(ij)*cos(rlatu((ij-1)/iip1+1))
  !  enddo

  if(dyqv(ismin(iim,dyqv,1))*dyqv(ismax(iim,dyqv,1)).le.0.) &
        then
     do ij=1,iip1
        dyqmax(ij)=0.
     enddo
  else
     do ij=1,iip1
        dyqmax(ij)=pente_max*abs(dyqv(ij))
     enddo
  endif

  if(dyqv(ismax(iim,dyqv(ip1jm-iip1+1),1)+ip1jm-iip1+1)* &
        dyqv(ismin(iim,dyqv(ip1jm-iip1+1),1)+ip1jm-iip1+1).le.0.) &
        then
     do ij=ip1jm+1,ip1jmp1
        dyqmax(ij)=0.
     enddo
  else
     do ij=ip1jm+1,ip1jmp1
        dyqmax(ij)=pente_max*abs(dyqv(ij-iip1))
     enddo
  endif

  !   calcul des pentes limitees

  do ij=1,ip1jmp1
     if(dyqv(ij)*dyqv(ij-iip1).gt.0.) then
        dyq(ij)=sign(min(abs(dyq(ij)),dyqmax(ij)),dyq(ij))
     else
        dyq(ij)=0.
     endif
  enddo

     DO ij=1,ip1jmp1
           sy(ij,l) = dyq(ij) * sm ( ij,l )
    ENDDO

  enddo ! fin de la boucle sur les couches verticales

  RETURN
END SUBROUTINE limy
