!
! $Header$
!
SUBROUTINE laplacien_rotgam ( klevel, rotin, rotout )
  !
  ! P. Le Van
  !
  !   ************************************************************
  !   ... calcul de  (rotat x nxgrad)_gam  du rotationnel rotin ..
  !   ************************************************************
  ! klevel et teta  sont des arguments  d'entree pour le s-prog
  !  divgra     est  un argument  de sortie pour le s-prog
  !
  USE comgeom_mod_h
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h, ONLY: iip1, iip2, iip3, jjp1, llmp1, llmp2, llmm1, kftd, ip1jm, ip1jmp1, &
          ip1jmi1, ijp1llm, ijmllm, mvar, jcfil, jcfllm
IMPLICIT NONE
  !



  !
  !    .............   variables  en  arguments    ...........
  !
  INTEGER :: klevel
  REAL :: rotin( ip1jm,klevel ), rotout( ip1jm,klevel )
  !
  !   ............     variables   locales     ...............
  !
  INTEGER :: l, ij
  REAL :: ghy(ip1jm,llm), ghx(ip1jmp1,llm)
  !   ........................................................
  !
  !

  CALL   nxgrad_gam ( klevel, rotin,   ghx ,   ghy  )
  CALL   rotat_nfil ( klevel, ghx  ,   ghy , rotout )
  !
  DO l = 1, klevel
    DO ij = 1, ip1jm
     rotout(ij,l) = rotout(ij,l) * unsairz_gam(ij)
    ENDDO
  ENDDO

  RETURN
END SUBROUTINE laplacien_rotgam
