!
! $Header$
!
SUBROUTINE diverg_gam(klevel,cuvscvgam,cvuscugam,unsairegam , &
        unsapolnga,unsapolsga,  x, y,  div )
  !
  ! P. Le Van
  !
  !  *********************************************************************
  !  ... calcule la divergence a tous les niveaux d'1 vecteur de compos.
  ! x et y...
  !          x et y  etant des composantes covariantes   ...
  !  *********************************************************************
  USE comgeom_mod_h
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h, ONLY: iip1, iip2, iip3, jjp1, llmp1, llmp2, llmm1, kftd, ip1jm, ip1jmp1, &
          ip1jmi1, ijp1llm, ijmllm, mvar, jcfil, jcfllm
IMPLICIT NONE
  !
  !  x  et  y  sont des arguments  d'entree pour le s-prog
  !    div      est  un argument  de sortie pour le s-prog
  !
  !
  !   ---------------------------------------------------------------------
  !
  !    ATTENTION : pendant ce s-pg , ne pas toucher au COMMON/scratch/  .
  !
  !   ---------------------------------------------------------------------


  !
  !    ..........          variables en arguments    ...................
  !
  INTEGER :: klevel
  REAL :: x( ip1jmp1,klevel ),y( ip1jm,klevel ),div( ip1jmp1,klevel )
  REAL :: cuvscvgam(ip1jm),cvuscugam(ip1jmp1),unsairegam(ip1jmp1)
  REAL :: unsapolnga,unsapolsga
  !
  !    ...............     variables  locales   .........................

  REAL :: aiy1( iip1 ) , aiy2( iip1 )
  REAL :: sumypn,sumyps
  INTEGER :: l,ij
  !    ...................................................................
  !
  REAL :: SSUM
  !
  !
  DO l = 1,klevel
  !
    DO  ij = iip2, ip1jm - 1
     div( ij + 1, l )     = ( &
           cvuscugam( ij+1 ) * x( ij+1,l ) - cvuscugam( ij ) * x( ij , l) + &
           cuvscvgam(ij-iim) * y(ij-iim,l) - cuvscvgam(ij+1) * y(ij+1,l) )* &
           unsairegam( ij+1 )
    ENDDO
  !
  ! ....  correction pour  div( 1,j,l)  ......
  ! ....   div(1,j,l)= div(iip1,j,l) ....
  !
  !DIR$ IVDEP
    DO  ij = iip2,ip1jm,iip1
     div( ij,l ) = div( ij + iim,l )
    ENDDO
  !
  ! ....  calcul  aux poles  .....
  !
    DO  ij  = 1,iim
     aiy1(ij) =    cuvscvgam(    ij       ) * y(     ij     , l )
     aiy2(ij) =    cuvscvgam( ij+ ip1jmi1 ) * y( ij+ ip1jmi1, l )
    ENDDO
    sumypn = SSUM ( iim,aiy1,1 ) * unsapolnga
    sumyps = SSUM ( iim,aiy2,1 ) * unsapolsga
  !
    DO  ij = 1,iip1
     div(     ij    , l ) = - sumypn
     div( ij + ip1jm, l ) =   sumyps
    ENDDO
  END DO
  !

   RETURN
END SUBROUTINE diverg_gam
