!
! $Header$
!
SUBROUTINE nxgrarot (klevel,xcov, ycov, lr, grx, gry )
  !   ***********************************************************
  !
  !    Auteur :  P.Le Van
  !
  !                             lr
  !  calcul de  ( nXgrad (rot) )   du vect. v  ....
  !
  !   xcov et ycov  etant les compos. covariantes de  v
  !   ***********************************************************
  ! xcov , ycov et lr  sont des arguments  d'entree pour le s-prog
  !  grx   et  gry     sont des arguments de sortie pour le s-prog
  !
  !
  USE comdissipn_mod_h
  USE dimensions_mod, ONLY: iim, jjm, llm, ndm
USE paramet_mod_h, ONLY: iip1, iip2, iip3, jjp1, llmp1, llmp2, llmm1, kftd, ip1jm, ip1jmp1, &
          ip1jmi1, ijp1llm, ijmllm, mvar, jcfil, jcfllm
IMPLICIT NONE
  !
  !


  !
  INTEGER :: klevel
  REAL :: xcov( ip1jmp1,klevel ), ycov( ip1jm,klevel )
  REAL :: grx( ip1jmp1,klevel ),  gry( ip1jm,klevel )
  !
  REAL :: rot(ip1jm,llm)

  INTEGER :: l,ij,iter,lr
  !
  !
  !
  CALL SCOPY ( ip1jmp1*klevel, xcov, 1, grx, 1 )
  CALL SCOPY (  ip1jm*klevel, ycov, 1, gry, 1 )
  !
  DO iter = 1,lr
  CALL  rotat (klevel,grx, gry, rot )
  CALL filtreg( rot, jjm, klevel, 2,1, .false.,2)
  CALL nxgrad (klevel,rot, grx, gry )
  !
  DO  l = 1, klevel
  DO ij = 1, ip1jm
  gry( ij,l ) = - gry( ij,l ) * crot
  END DO
  DO ij = 1, ip1jmp1
  grx( ij,l ) = - grx( ij,l ) * crot
  END DO
  END DO
  !
  END DO
  RETURN
END SUBROUTINE nxgrarot
