!
! $Id: abort_gcm.F90 5267 2024-10-23 15:34:46Z abarral $
!
!
!
SUBROUTINE abort_gcm(modname, message, ierr)

  USE IOIPSL
  !! ug Pour les sorties XIOS
  USE wxios

#include "iniprint.h"

  !
  ! Stops the simulation cleanly, closing files and printing various
  ! comments
  !
  !  Input: modname = name of calling program
  !     message = stuff to print
  !     ierr    = severity of situation ( = 0 normal )

  character(len=*), intent(in):: modname
  integer, intent(in):: ierr
  character(len=*), intent(in):: message

  write(lunout,*) 'in abort_gcm'

  IF (using_xios) THEN
  !Fermeture propre de XIOS
    CALL wxios_close()
  ENDIF

  call histclo
  call restclo
  call getin_dump
  ! call histclo(2)
  ! call histclo(3)
  ! call histclo(4)
  ! call histclo(5)
  write(lunout,*) 'Stopping in ', modname
  write(lunout,*) 'Reason = ',message
  if (ierr .eq. 0) then
    write(lunout,*) 'Everything is cool'
    stop
  else
    write(lunout,*) 'Houston, we have a problem, ierr = ', ierr
    stop 1
  endif
END SUBROUTINE abort_gcm
