! reprobus SUBROUTINE wrappers

MODULE lmdz_reprobus_wrappers

#ifdef REPROBUS
  USE CHEM_REP, ONLY: init_chem_rep_trac, itroprep
#else

  ! TODO ugly temp solution until we properly wrap the REPROBUS code
  INCLUDE "dimensions.h"
  INTEGER :: itroprep(iim), iter, ndimozon
  REAL :: rsuntime(2), pdt_rep, daynum, solaireTIME, ptrop(iim), ttrop(iim), ztrop(iim), gravit, Z1, &
          Z2, fac, B
  REAL, DIMENSION(iim, jjm) :: pdel, d_q_rep, d_ql_rep, d_qi_rep, rch42d, rn2o2d, rcfc112d, rcfc122d
  LOGICAL :: ok_suntime, ok_rtime2d

CONTAINS

  SUBROUTINE lmdz_reprobus_wrapper_abort
    STOP 'REPROBUS key undefined, must not enter in REPROBUS wrappers ==> aborting'
  END SUBROUTINE lmdz_reprobus_wrapper_abort

  ! TODO replace ugly wrappers below with actual signatures from REPROBUS code

  SUBROUTINE init_chem_rep_trac(nbtr, nqo, name)
    INTEGER :: nbtr, nqo
    CHARACTER(len = 256) :: name(:)
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE init_chem_rep_trac

  SUBROUTINE init_chem_rep_phys(klon, klev)
    INTEGER :: klon, klev
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE init_chem_rep_phys

  SUBROUTINE init_chem_rep_xjour(j)
    REAL :: j
    CALL lmdz_reprobus_wrapper_abort
  END SUBROUTINE init_chem_rep_xjour

#endif
END MODULE lmdz_reprobus_wrappers