! inca SUBROUTINE wrappers

#ifndef INCA

SUBROUTINE lmdz_inca_wrapper_abort
  STOP 'INCA key undefined, must not enter in INCA wrappers ==> aborting'
END SUBROUTINE lmdz_inca_wrapper_abort

SUBROUTINE init_chem_inca_trac(nbtr)
  IMPLICIT NONE
  INTEGER, INTENT(OUT) :: nbtr

  CALL lmdz_inca_wrapper_abort
END SUBROUTINE init_chem_inca_trac

SUBROUTINE init_transport(&
        tracnam_lmdz, &
        conv_flg_lmdz, &
        pbl_flg_lmdz, &
        hadv_flg_lmdz, &
        vadv_flg_lmdz)
  IMPLICIT NONE
  INTEGER, DIMENSION(:), INTENT(OUT) :: hadv_flg_lmdz
  INTEGER, DIMENSION(:), INTENT(OUT) :: vadv_flg_lmdz

  INTEGER, DIMENSION(:), INTENT(OUT) :: conv_flg_lmdz
  INTEGER, DIMENSION(:), INTENT(OUT) :: pbl_flg_lmdz
  CHARACTER(len = 8), DIMENSION(:), INTENT(OUT) :: tracnam_lmdz

  CALL lmdz_inca_wrapper_abort
END SUBROUTINE init_transport

SUBROUTINE finalize_inca
  IMPLICIT NONE
  CALL lmdz_inca_wrapper_abort
END SUBROUTINE finalize_inca

SUBROUTINE CHEMHOOK_BEGIN(&
        calday, &
        ijour, &
        gmtime, &
        oro, &
        lat, &
        lon, &
        area, &
        pfull, &
        pmid, &
        coefh, &
        zma, &
        temp, &
        u, &
        v, &
        rot, &
        ozrad, &
        sh, &
        ts, &
        t_air_2m, &
        dpth_snow, &
        sws, &
        albs, &
        rain_fall, &
        snow_fall, &
        ctop, &
        cbot, &
        cldfr, &
        nx, &
        ny, &
        mmr, &
        ftsol, &
        paprs, &
        cdragh, &
        cdragm, &
        pctsrf, &
        delt, &
        nstep)
  IMPLICIT NONE
  REAL, INTENT(IN) :: calday
  INTEGER, INTENT(IN) :: ijour  ! jour julien
  REAL, INTENT(IN) :: gmtime ! input-R-temps universel dans la journee (0 a 86400 s)
  INTEGER, INTENT(IN) :: ctop(:)
  INTEGER, INTENT(IN) :: cbot(:)
  INTEGER, INTENT(IN) :: nx, ny
  REAL, INTENT(IN) :: pmid(:, :)
  REAL, INTENT(IN) :: pfull(:, :)
  REAL, INTENT(IN) :: coefh(:, :)
  REAL, INTENT(IN) :: zma(:, :)
  REAL, INTENT(IN) :: temp(:, :)
  REAL, INTENT(IN) :: u(:, :)
  REAL, INTENT(IN) :: v(:, :)
  REAL, INTENT(IN) :: rot(:, :)
  REAL, INTENT(IN) :: ozrad(:, :)
  REAL, INTENT(IN) :: sh(:, :)
  REAL, INTENT(IN) :: lat(:)
  REAL, INTENT(IN) :: lon(:)
  REAL, INTENT(IN) :: oro(:)
  REAL, INTENT(IN) :: area(:)
  REAL, INTENT(IN) :: ts(:)
  REAL, INTENT(IN) :: t_air_2m(:) ! air temperature near surface
  REAL, INTENT(IN) :: dpth_snow(:)
  REAL, INTENT(IN) :: sws(:)
  REAL, INTENT(IN) :: albs(:)
  REAL, INTENT(IN) :: rain_fall(:)
  REAL, INTENT(IN) :: snow_fall(:)
  REAL, INTENT(IN) :: mmr(:, :, :)
  REAL, INTENT(IN) :: cldfr (:, :)
  ! variables used in nightingale
  REAL, INTENT(IN) :: ftsol(:, :)
  REAL, INTENT(IN) :: paprs(:, :)
  REAL, INTENT(IN) :: cdragh(:), cdragm(:)
  REAL, INTENT(IN) :: pctsrf(:, :)
  REAL, INTENT(IN) :: delt               ! timestep in seconds of physics
  INTEGER, INTENT(IN) :: nstep              ! model time step

  CALL lmdz_inca_wrapper_abort
END SUBROUTINE CHEMHOOK_BEGIN

SUBROUTINE CHEMHOOK_END(&
        dt, &
        pmid, &
        temp, &
        mmr, &
        nbtr, &
        paprs, &
        sh, &
        area, &
        zma, &
        phis, &
        rh, aps, bps, ap, bp, lafin)
  IMPLICIT NONE
  INTEGER, INTENT(IN) :: nbtr
  REAL, INTENT(IN) :: dt
  REAL, INTENT(IN) :: pmid(:, :)
  REAL, INTENT(IN) :: area(:)
  REAL, INTENT(IN) :: temp(:, :)
  REAL, INTENT(IN) :: paprs(:, :)
  REAL, INTENT(IN) :: sh(:, :)
  REAL, INTENT(INOUT) :: mmr(:, :, :)
  REAL, INTENT(IN) :: zma(:, :)
  REAL, INTENT(IN) :: phis(:)
  REAL, INTENT(IN) :: rh(:, :)
  REAL, INTENT(IN), DIMENSION(:) :: aps, bps
  REAL, INTENT(IN), DIMENSION(:) :: ap, bp
  LOGICAL, INTENT(IN) :: lafin

  CALL lmdz_inca_wrapper_abort
END SUBROUTINE chemhook_end

SUBROUTINE chemtime(istp, date0, dt, itap)
  IMPLICIT NONE
  INTEGER, INTENT(IN) :: istp   ! time step of the restart file
  REAL, INTENT(IN) :: date0  ! the date at which itau = 0
  REAL, INTENT(IN) :: dt     ! time step
  INTEGER, INTENT(IN) :: itap
  CALL lmdz_inca_wrapper_abort
END SUBROUTINE chemtime

SUBROUTINE INIT_CONST_LMDZ(&
        nday_l, &
        nbsrf_l, &
        is_oce_l, &
        is_sic_l, &
        is_ter_l, &
        is_lic_l, &
        calend_l, &
        config_inca_l)
  IMPLICIT NONE
  INTEGER, INTENT(IN) :: nday_l
  INTEGER, INTENT(IN) :: nbsrf_l
  INTEGER, INTENT(IN) :: is_oce_l, is_sic_l, is_lic_l, is_ter_l
  CHARACTER (len = 10), INTENT(IN) :: calend_l
  CHARACTER(len = 4), INTENT(IN) :: config_inca_l

  CALL lmdz_inca_wrapper_abort
END SUBROUTINE init_const_lmdz

SUBROUTINE init_inca_geometry(&
        longitude_lmdz, latitude_lmdz, &
        boundslon_lmdz, boundslat_lmdz, &
        cell_area_lmdz, &
        ind_cell_glo_lmdz)
  IMPLICIT NONE
  REAL, INTENT(IN) :: longitude_lmdz(:)
  REAL, INTENT(IN) :: latitude_lmdz(:)
  REAL, INTENT(IN) :: boundslon_lmdz(:, :)
  REAL, INTENT(IN) :: boundslat_lmdz(:, :)
  REAL, INTENT(IN) :: cell_area_lmdz(:)
  INTEGER, OPTIONAL, INTENT(IN) :: ind_cell_glo_lmdz(:)

  CALL lmdz_inca_wrapper_abort
END SUBROUTINE init_inca_geometry

SUBROUTINE CHEMINI(pmid, &
        nbp_lon_lmdz, nbp_lat_lmdz, &
        latgcm, &
        longcm, &
        presnivs, &
        calday, &
        klon, &
        nqmax, &
        nqo, &
        pdtphys, &
        annee_ref, &
        year_cur, &
        day_ref, &
        day_ini, &
        start_time, &
        itau_phy, &
        date0, &
        chemistry_couple, &
        init_source, &
        init_tauinca, &
        init_pizinca, &
        init_cginca, &
        init_ccm, &
        io_lon, &
        io_lat)
  IMPLICIT NONE
  REAL, INTENT(IN) :: pmid(:, :)
  INTEGER, INTENT(IN) :: nbp_lon_lmdz, nbp_lat_lmdz
  REAL, INTENT(IN) :: calday
  REAL, INTENT(IN) :: latgcm(:)
  REAL, INTENT(IN) :: longcm(:)
  REAL, INTENT(IN) :: presnivs(:)
  INTEGER, INTENT(IN) :: klon
  INTEGER, INTENT(IN) :: nqmax  ! nombre total de traceurs = inca + lmdz
  INTEGER, INTENT(IN) :: nqo ! nombre de traceurs lus dans traceur.def
  REAL, INTENT(IN) :: pdtphys
  INTEGER, INTENT(IN) :: annee_ref, year_cur
  INTEGER, INTENT(IN) :: day_ref, day_ini
  REAL, INTENT(IN) :: start_time
  INTEGER, INTENT(IN) :: itau_phy
  REAL, OPTIONAL, INTENT(IN) :: io_lat(nbp_lat_lmdz) ! latitudes (of global grid)
  REAL, OPTIONAL, INTENT(IN) :: io_lon(nbp_lon_lmdz) ! longitudes (of global grid)
  REAL, INTENT(IN) :: date0
  LOGICAL, INTENT(IN) :: chemistry_couple
  REAL, DIMENSION(:, :), INTENT(OUT) :: init_source
  REAL, DIMENSION(:, :, :, :), INTENT(OUT) :: init_tauinca
  REAL, DIMENSION(:, :, :, :), INTENT(OUT) :: init_pizinca
  REAL, DIMENSION(:, :, :, :), INTENT(OUT) :: init_cginca
  REAL, DIMENSION(:, :, :), INTENT(OUT) :: init_ccm

  CALL lmdz_inca_wrapper_abort
END SUBROUTINE chemini

SUBROUTINE radlwsw_inca(chemistry_couple, kdlon, kflev, dist, rmu0, fract, &
        solaire, paprs, pplay, tsol, albedo, alblw, t, q, size_wo, wo, &
        cldfra, cldemi, cldtaupd, &
        heat, heat0, cool, cool0, albpla, &
        topsw, toplw, solsw, sollw, &
        sollwdown, &
        topsw0, toplw0, solsw0, sollw0, &
        lwdn0, lwdn, lwup0, lwup, &
        swdn0, swdn, swup0, swup, &
        ok_ade, ok_aie, &
        tau_inca, piz_inca, cg_inca, &
        topswad_inca, solswad_inca, &
        topswad0_inca, solswad0_inca, &
        topsw_inca, topsw0_inca, &
        solsw_inca, solsw0_inca, &
        cldtaupi, topswai_inca, solswai_inca)
  IMPLICIT NONE
  LOGICAL, INTENT(IN) :: chemistry_couple
  INTEGER, INTENT(IN) :: kdlon, kflev
  REAL, INTENT(IN) :: solaire
  REAL, INTENT(IN) :: dist
  REAL, INTENT(IN) :: rmu0(:), fract(:)
  REAL, INTENT(IN) :: paprs(:, :), pplay(:, :)
  REAL, INTENT(IN) :: albedo(:), alblw(:), tsol(:)
  REAL, INTENT(IN) :: t(:, :), q(:, :)
  INTEGER, INTENT(IN) :: size_wo
  REAL, INTENT(IN) :: wo(:, :, :)  ! column-density of ozone in a layer, in kilo-Dobsons
  LOGICAL, INTENT(IN) :: ok_ade, ok_aie     ! switches whether to use aerosol direct (indirect) effects or not
  REAL, INTENT(IN) :: cldfra(:, :), cldemi(:, :), cldtaupd(:, :)
  REAL, INTENT(IN) :: tau_inca(:, :, :, :) ! aerosol optical properties (see aeropt.F)
  REAL, INTENT(IN) :: piz_inca(:, :, :, :) ! aerosol optical properties (see aeropt.F)
  REAL, INTENT(IN) :: cg_inca(:, :, :, :)        ! aerosol optical properties (see aeropt.F)
  REAL, INTENT(IN) :: cldtaupi(:, :)  ! cloud optical thickness for pre-industrial aerosol concentrations
  REAL, INTENT(OUT) :: heat(:, :), cool(:, :)
  REAL, INTENT(OUT) :: heat0(:, :), cool0(:, :)
  REAL, INTENT(OUT) :: topsw(:), toplw(:)
  REAL, INTENT(OUT) :: solsw(:), sollw(:), albpla(:)
  REAL, INTENT(OUT) :: topsw0(:), toplw0(:), solsw0(:), sollw0(:)
  REAL, INTENT(OUT) :: sollwdown(:)
  REAL, INTENT(OUT) :: swdn(:, :), swdn0(:, :)
  REAL, INTENT(OUT) :: swup(:, :), swup0(:, :)
  REAL, INTENT(OUT) :: lwdn(:, :), lwdn0(:, :)
  REAL, INTENT(OUT) :: lwup(:, :), lwup0(:, :)
  REAL, INTENT(OUT) :: topswad_inca(:), solswad_inca(:) ! output: aerosol direct forcing at TOA and surface
  REAL, INTENT(OUT) :: topswad0_inca(:), solswad0_inca(:) ! output: aerosol direct forcing at TOA and surface
  REAL, INTENT(OUT) :: topswai_inca(:), solswai_inca(:) ! output: aerosol indirect forcing atTOA and surface
  REAL(kind = 8), INTENT(OUT) :: topsw_inca(:, :), topsw0_inca(:, :)
  REAL(kind = 8), INTENT(OUT) :: solsw_inca(:, :), solsw0_inca(:, :)

  CALL lmdz_inca_wrapper_abort
END SUBROUTINE radlwsw_inca

SUBROUTINE INIT_INCA_DIM_REG(&
        iim, &
        jjm, &
        rlonu_l, &
        rlatu_l, &
        rlonv_l, &
        rlatv_l)

  IMPLICIT NONE
  INTEGER, INTENT(IN) :: iim
  INTEGER, INTENT(IN) :: jjm
  REAL, INTENT(IN) :: rlonu_l(:)
  REAL, INTENT(IN) :: rlatu_l(:)
  REAL, INTENT(IN) :: rlonv_l(:)
  REAL, INTENT(IN) :: rlatv_l(:)

  CALL lmdz_inca_wrapper_abort
END SUBROUTINE INIT_INCA_DIM_REG

SUBROUTINE AEROSOL_METEO_CALC(&
        calday, delt, pmid, pfull, t_seri, &
        flxrcv, flxscv, flxrst, flxsst, pctsrf, &
        area, rlat, rlon, u10m, v10m)
  IMPLICIT NONE
  REAL, INTENT(IN) :: calday
  REAL, INTENT(IN) :: delt                ! [s]
  REAL, INTENT(IN) :: pmid(:, :)     ! [Pa]
  REAL, INTENT(IN) :: pfull(:, :)  ! [Pa]
  REAL, INTENT(IN) :: t_seri(:, :)   ! [K]
  REAL, INTENT(IN) :: flxrst(:, :) ! liquid water flux (stratiform) kgH2O/m2/s
  REAL, INTENT(IN) :: flxrcv(:, :) ! liquid  water flux (convection ) kgH2O/m2/s
  REAL, INTENT(IN) :: flxsst(:, :) ! solid  water flux (stratiform) kgH2O/m2/s
  REAL, INTENT(IN) :: flxscv(:, :) ! solid  water flux (convection) kgH2O/m2/s
  REAL, INTENT(IN) :: pctsrf(:, :)  ! subsurface fraction (0..1)
  REAL, INTENT(IN) :: area(:)          ! surface area of grid box [m2]
  REAL, INTENT(IN) :: rlon(:)          ! longitude
  REAL, INTENT(IN) :: rlat(:)          ! latitude
  REAL, INTENT(IN) :: u10m(:, :)    ! vents a 10m
  REAL, INTENT(IN) :: v10m(:, :)    ! vents a 10m

  CALL lmdz_inca_wrapper_abort
END SUBROUTINE AEROSOL_METEO_CALC

#endif
