! Subroutine that calculates the effect of precipitation in scavenging
! WITHIN the cloud, for large scale as well as convective precipitation
SUBROUTINE incloud_scav(lminmax, qmin, qmax, masse, henry, kk, prfl, &
        psfl, pmflxr, pmflxs, zrho, zdz, t_seri, pdtphys, &
        his_dhlsc, his_dhcon1, tr_seri)

  USE dimphy
  USE lmdz_infotrac
  USE indice_sol_mod
  USE lmdz_yomcst

USE lmdz_dimensions, ONLY: iim, jjm, llm, ndm
  USE lmdz_paramet
USE lmdz_chem, ONLY: idms, iso2, iso4, ih2s, idmso, imsa, ih2o2, &
          n_avogadro, masse_s, masse_so4, rho_water, rho_ice
  IMPLICIT NONE




  !============================= INPUT ===================================
  REAL :: qmin, qmax
  REAL :: masse(nbtr)
  REAL :: henry(nbtr)         !--cste de Henry  mol/l/atm
  REAL :: kk(nbtr)            !--coefficient de var avec T (K)
  REAL :: prfl(klon, klev + 1), psfl(klon, klev + 1)     !--large-scale
  ! REAL prfl(klon,klev),   psfl(klon,klev)     !--large-scale
  REAL :: pmflxr(klon, klev + 1), pmflxs(klon, klev + 1)   !--convection
  ! REAL pmflxr(klon,klev), pmflxs(klon,klev)   !--convection
  REAL :: zrho(klon, klev), zdz(klon, klev)
  REAL :: t_seri(klon, klev)
  LOGICAL :: lminmax
  REAL :: pdtphys
  ! REAL prfl(klon,klev+1),   psfl(klon,klev+1)     !--large-scale  ! Titane
  ! REAL pmflxr(klon,klev+1), pmflxs(klon,klev+1)   !--convection   ! Titane
  !============================= OUTPUT ==================================
  REAL :: tr_seri(klon, klev, nbtr) ! traceur
  REAL :: aux_var1(klon, klev) ! traceur
  REAL :: aux_var2(klon) ! traceur
  REAL :: aux_var3(klon) ! traceur
  REAL :: his_dhlsc(klon, nbtr)        ! in-cloud scavenging lsc
  REAL :: his_dhcon1(klon, nbtr)       ! in-cloud scavenging con
  !========================= LOCAL VARIABLES =============================
  INTEGER :: it, i, j

  EXTERNAL minmaxqfi, inscav_spl

  DO it = 1, nbtr

    DO i = 1, klon
      aux_var2(i) = his_dhlsc(i, it)
      aux_var3(i) = his_dhcon1(i, it)
    ENDDO
    DO j = 1, klev
      DO i = 1, klon
        aux_var1(i, j) = tr_seri(i, j, it)
      ENDDO
    ENDDO

    IF (lminmax) THEN
      CALL minmaxqfi(aux_var1, qmin, qmax, 'avt inscav')
      !nhl      CALL minmaxqfi(tr_seri(1,1,it),qmin,qmax,'avt inscav')
    ENDIF

    !nhl      CALL inscav_spl(pdtphys,it,masse(it),henry(it),kk(it),0.5e-3,
    !nhl     .             prfl,psfl,zrho,zdz,t_seri,tr_seri(1,1,it),
    !nhl     .             his_dhlsc(1,it))
    CALL inscav_spl(pdtphys, it, masse(it), henry(it), kk(it), 0.5e-3, &
            prfl, psfl, zrho, zdz, t_seri, aux_var1, aux_var2)

    IF (lminmax) THEN
      CALL minmaxqfi(aux_var1, qmin, qmax, 'depot humide lsc')
      !nhl      CALL minmaxqfi(tr_seri(1,1,it),qmin,qmax,'depot humide lsc')
    ENDIF


    !-scheme for convective in-cloud scavenging

    !nhl      CALL inscav_spl(pdtphys,it,masse(it),henry(it),kk(it),1.e-3,
    !nhl     .             pmflxr,pmflxs,zrho,zdz,t_seri,tr_seri(1,1,it),
    !nhl     .             his_dhcon1(1,it))
    CALL inscav_spl(pdtphys, it, masse(it), henry(it), kk(it), 1.e-3, &
            pmflxr, pmflxs, zrho, zdz, t_seri, aux_var1, aux_var3)

    IF (lminmax) THEN
      CALL minmaxqfi(aux_var1, qmin, qmax, 'depot humide con')
      !nhl      CALL minmaxqfi(tr_seri(1,1,it),qmin,qmax,'depot humide con')
    ENDIF

    DO j = 1, klev
      DO i = 1, klon
        tr_seri(i, j, it) = aux_var1(i, j)
      ENDDO
    ENDDO
    DO i = 1, klon
      his_dhlsc(i, it) = aux_var2(i)
      his_dhcon1(i, it) = aux_var3(i)
    ENDDO


  ENDDO !--boucle sur it

END SUBROUTINE incloud_scav
