! $Id: writedynav.F90 5182 2024-09-10 14:25:29Z abarral $

SUBROUTINE writedynav(time, vcov, ucov, teta, ppk, phi, q, masse, ps, phis)

  USE ioipsl
  USE lmdz_infotrac, ONLY: nqtot
  USE com_io_dyn_mod, ONLY: histaveid, histvaveid, histuaveid
  USE comconst_mod, ONLY: cpp
  USE temps_mod, ONLY: itau_dyn
  USE lmdz_description, ONLY: descript
  USE lmdz_iniprint, ONLY: lunout, prt_level
  USE lmdz_comgeom

  USE lmdz_dimensions, ONLY: iim, jjm, llm, ndm
  USE lmdz_paramet
  IMPLICIT NONE

  !   Ecriture du fichier histoire au format IOIPSL

  !   Appels succesifs des routines: histwrite

  !   Entree:
  !      time: temps de l'ecriture
  !      vcov: vents v covariants
  !      ucov: vents u covariants
  !      teta: temperature potentielle
  !      phi : geopotentiel instantane
  !      q   : traceurs
  !      masse: masse
  !      ps   :pression au sol
  !      phis : geopotentiel au sol

  !   L. Fairhead, LMD, 03/99

  !   Arguments

  REAL vcov(ip1jm, llm), ucov(ip1jmp1, llm)
  REAL teta(ip1jmp1 * llm), phi(ip1jmp1, llm), ppk(ip1jmp1 * llm)
  REAL ps(ip1jmp1), masse(ip1jmp1, llm)
  REAL phis(ip1jmp1)
  REAL q(ip1jmp1, llm, nqtot)
  INTEGER time

  ! This routine needs IOIPSL to work
  !   Variables locales

  INTEGER ndex2d(ip1jmp1), ndexu(ip1jmp1 * llm), ndexv(ip1jm * llm)
  INTEGER iq, ii, ll
  REAL tm(ip1jmp1 * llm)
  REAL vnat(ip1jm, llm), unat(ip1jmp1, llm)
  LOGICAL ok_sync
  INTEGER itau_w

  !-----------------------------------------------------------------

  !  Initialisations

  ndexu = 0
  ndexv = 0
  ndex2d = 0
  ok_sync = .TRUE.
  tm = 999.999
  vnat = 999.999
  unat = 999.999
  itau_w = itau_dyn + time

  ! Passage aux composantes naturelles du vent
  CALL covnat(llm, ucov, vcov, unat, vnat)

  !  Appels a histwrite pour l'ecriture des variables a sauvegarder

  !  Vents U

  CALL histwrite(histuaveid, 'u', itau_w, unat, &
          iip1 * jjp1 * llm, ndexu)

  !  Vents V

  CALL histwrite(histvaveid, 'v', itau_w, vnat, &
          iip1 * jjm * llm, ndexv)

  !  Temperature potentielle moyennee

  CALL histwrite(histaveid, 'theta', itau_w, teta, &
          iip1 * jjp1 * llm, ndexu)

  !  Temperature moyennee

  DO ii = 1, ijp1llm
    tm(ii) = teta(ii) * ppk(ii) / cpp
  enddo
  CALL histwrite(histaveid, 'temp', itau_w, tm, &
          iip1 * jjp1 * llm, ndexu)

  !  Geopotentiel

  CALL histwrite(histaveid, 'phi', itau_w, phi, &
          iip1 * jjp1 * llm, ndexu)

  !  Traceurs

  !  DO iq=1, nqtot
  !       CALL histwrite(histaveid, tracers(iq)%longName, itau_w, &
  !                   q(:, :, iq), iip1*jjp1*llm, ndexu)
  ! enddo

  !  Masse

  CALL histwrite(histaveid, 'masse', itau_w, masse, &
          iip1 * jjp1 * llm, ndexu)

  !  Pression au sol

  CALL histwrite(histaveid, 'ps', itau_w, ps, iip1 * jjp1, ndex2d)

  ! Geopotentiel au sol

  ! CALL histwrite(histaveid, 'phis', itau_w, phis, iip1*jjp1, ndex2d)

  IF (ok_sync) THEN
    CALL histsync(histaveid)
    CALL histsync(histvaveid)
    CALL histsync(histuaveid)
  ENDIF

END SUBROUTINE  writedynav
