! $Id: inithist.F90 5182 2024-09-10 14:25:29Z abarral $

SUBROUTINE inithist(day0, anne0, tstep, t_ops, t_wrt)

  USE IOIPSL
  USE lmdz_infotrac, ONLY: nqtot
  USE com_io_dyn_mod, ONLY: histid, histvid, histuid, &
          dynhist_file, dynhistv_file, dynhistu_file
  USE comconst_mod, ONLY: pi
  USE comvert_mod, ONLY: presnivs
  USE temps_mod, ONLY: itau_dyn
  USE lmdz_description, ONLY: descript
  USE lmdz_iniprint, ONLY: lunout, prt_level
  USE lmdz_comgeom

  USE lmdz_dimensions, ONLY: iim, jjm, llm, ndm
  USE lmdz_paramet
  IMPLICIT NONE


  !   Routine d'initialisation des ecritures des fichiers histoires LMDZ
  !   au format IOIPSL

  !   Appels succesifs des routines: histbeg
  !                              histhori
  !                              histver
  !                              histdef
  !                              histend

  !   Entree:

  !  infile: nom du fichier histoire a creer
  !  day0,anne0: date de reference
  !  tstep: duree du pas de temps en seconde
  !  t_ops: frequence de l'operation pour IOIPSL
  !  t_wrt: frequence d'ecriture sur le fichier
  !  nq: nombre de traceurs


  !   L. Fairhead, LMD, 03/99

  ! =====================================================================

  !   Declarations



  !   Arguments

  INTEGER :: day0, anne0
  REAL :: tstep, t_ops, t_wrt

  ! This routine needs IOIPSL to work
  !   Variables locales

  INTEGER :: tau0
  REAL :: zjulian
  INTEGER :: iq
  REAL :: rlong(iip1, jjp1), rlat(iip1, jjp1)
  INTEGER :: uhoriid, vhoriid, thoriid, zvertiid
  INTEGER :: ii, jj
  INTEGER :: zan, dayref

  !  Initialisations

  pi = 4. * atan (1.)

  !  Appel a histbeg: creation du fichier netcdf et initialisations diverses
  !

  zan = anne0
  dayref = day0
  CALL ymds2ju(zan, 1, dayref, 0.0, zjulian)
  tau0 = itau_dyn

  ! -------------------------------------------------------------
  ! Creation des 3 fichiers pour les grilles horizontales U,V,Scal
  ! -------------------------------------------------------------
  !Grille U
  DO jj = 1, jjp1
    DO ii = 1, iip1
      rlong(ii, jj) = rlonu(ii) * 180. / pi
      rlat(ii, jj) = rlatu(jj) * 180. / pi
    enddo
  enddo

  CALL histbeg(dynhistu_file, iip1, rlong(:, 1), jjp1, rlat(1, :), &
          1, iip1, 1, jjp1, &
          tau0, zjulian, tstep, uhoriid, histuid)

  ! Grille V
  DO jj = 1, jjm
    DO ii = 1, iip1
      rlong(ii, jj) = rlonv(ii) * 180. / pi
      rlat(ii, jj) = rlatv(jj) * 180. / pi
    enddo
  enddo

  CALL histbeg(dynhistv_file, iip1, rlong(:, 1), jjm, rlat(1, :), &
          1, iip1, 1, jjm, &
          tau0, zjulian, tstep, vhoriid, histvid)

  !Grille Scalaire
  DO jj = 1, jjp1
    DO ii = 1, iip1
      rlong(ii, jj) = rlonv(ii) * 180. / pi
      rlat(ii, jj) = rlatu(jj) * 180. / pi
    enddo
  enddo

  CALL histbeg(dynhist_file, iip1, rlong(:, 1), jjp1, rlat(1, :), &
          1, iip1, 1, jjp1, &
          tau0, zjulian, tstep, thoriid, histid)
  ! -------------------------------------------------------------
  !  Appel a histvert pour la grille verticale
  ! -------------------------------------------------------------
  CALL histvert(histid, 'presnivs', 'Niveaux pression', 'mb', &
          llm, presnivs / 100., zvertiid, 'down')
  CALL histvert(histvid, 'presnivs', 'Niveaux pression', 'mb', &
          llm, presnivs / 100., zvertiid, 'down')
  CALL histvert(histuid, 'presnivs', 'Niveaux pression', 'mb', &
          llm, presnivs / 100., zvertiid, 'down')

  ! -------------------------------------------------------------
  !  Appels a histdef pour la definition des variables a sauvegarder
  ! -------------------------------------------------------------

  !  Vents U

  CALL histdef(histuid, 'u', 'vent u', 'm/s', &
          iip1, jjp1, uhoriid, llm, 1, llm, zvertiid, &
          32, 'inst(X)', t_ops, t_wrt)

  !  Vents V

  CALL histdef(histvid, 'v', 'vent v', 'm/s', &
          iip1, jjm, vhoriid, llm, 1, llm, zvertiid, &
          32, 'inst(X)', t_ops, t_wrt)


  !  Temperature potentielle

  CALL histdef(histid, 'teta', 'temperature potentielle', '-', &
          iip1, jjp1, thoriid, llm, 1, llm, zvertiid, &
          32, 'inst(X)', t_ops, t_wrt)

  !  Geopotentiel

  CALL histdef(histid, 'phi', 'geopotentiel', '-', &
          iip1, jjp1, thoriid, llm, 1, llm, zvertiid, &
          32, 'inst(X)', t_ops, t_wrt)

  !  Traceurs
  !

  !    DO iq=1,nqtot
  !      CALL histdef(histid, tracers(iq)%name,
  !                           tracers(iq)%longName, '-',
  ! .             iip1, jjp1, thoriid, llm, 1, llm, zvertiid,
  ! .             32, 'inst(X)', t_ops, t_wrt)
  !    enddo
  !C
  !  Masse

  CALL histdef(histid, 'masse', 'masse', 'kg', &
          iip1, jjp1, thoriid, llm, 1, llm, zvertiid, &
          32, 'inst(X)', t_ops, t_wrt)

  !  Pression au sol

  CALL histdef(histid, 'ps', 'pression naturelle au sol', 'Pa', &
          iip1, jjp1, thoriid, 1, 1, 1, -99, &
          32, 'inst(X)', t_ops, t_wrt)

  !  Geopotentiel au sol
  !C
  !  CALL histdef(histid, 'phis', 'geopotentiel au sol', '-',
  ! .             iip1, jjp1, thoriid, 1, 1, 1, -99,
  ! .             32, 'inst(X)', t_ops, t_wrt)
  !C
  !  Fin

  CALL histend(histid)
  CALL histend(histuid)
  CALL histend(histvid)
END SUBROUTINE  inithist
