! $Id: initdynav.F90 5182 2024-09-10 14:25:29Z abarral $

SUBROUTINE initdynav(day0, anne0, tstep, t_ops, t_wrt)

  USE IOIPSL
  USE lmdz_infotrac, ONLY: nqtot
  USE com_io_dyn_mod, ONLY: histaveid, histvaveid, histuaveid, &
          dynhistave_file, dynhistvave_file, dynhistuave_file
  USE comconst_mod, ONLY: pi
  USE comvert_mod, ONLY: presnivs
  USE temps_mod, ONLY: itau_dyn
  USE lmdz_description, ONLY: descript
  USE lmdz_iniprint, ONLY: lunout, prt_level
  USE lmdz_comgeom

  USE lmdz_dimensions, ONLY: iim, jjm, llm, ndm
  USE lmdz_paramet
  IMPLICIT NONE


  !   Routine d'initialisation des ecritures des fichiers histoires LMDZ
  !   au format IOIPSL. Initialisation du fichier histoire moyenne.

  !   Appels succesifs des routines: histbeg
  !                                  histhori
  !                                  histver
  !                                  histdef
  !                                  histend

  !   Entree:

  !      infile: nom du fichier histoire a creer
  !      day0,anne0: date de reference
  !      tstep : frequence d'ecriture
  !      t_ops: frequence de l'operation pour IOIPSL
  !      t_wrt: frequence d'ecriture sur le fichier


  !   L. Fairhead, LMD, 03/99




  !   Arguments

  INTEGER day0, anne0
  REAL tstep, t_ops, t_wrt

  ! This routine needs IOIPSL to work
  !   Variables locales

  INTEGER tau0
  REAL zjulian
  INTEGER iq
  REAL rlong(iip1, jjp1), rlat(iip1, jjp1)
  INTEGER uhoriid, vhoriid, thoriid, zvertiid
  INTEGER ii, jj
  INTEGER zan, dayref

  !--------------------------------------------------------------------

  !  Initialisations

  pi = 4. * atan (1.)

  !  Appel a histbeg: creation du fichier netcdf et initialisations diverses

  zan = anne0
  dayref = day0
  CALL ymds2ju(zan, 1, dayref, 0.0, zjulian)
  tau0 = itau_dyn

  DO jj = 1, jjp1
    DO ii = 1, iip1
      rlong(ii, jj) = rlonv(ii) * 180. / pi
      rlat(ii, jj) = rlatu(jj) * 180. / pi
    enddo
  enddo

  ! Creation de 3 fichiers pour les differentes grilles horizontales
  ! Restriction de IOIPSL: seulement 2 coordonnees dans le meme fichier
  ! Grille Scalaire
  CALL histbeg(dynhistave_file, iip1, rlong(:, 1), jjp1, rlat(1, :), &
          1, iip1, 1, jjp1, &
          tau0, zjulian, tstep, thoriid, histaveid)

  ! Creation du fichier histoire pour les grilles en V et U (oblige
  ! pour l'instant, IOIPSL ne permet pas de grilles avec des nombres
  ! de point differents dans  un meme fichier)
  ! Grille V
  DO jj = 1, jjm
    DO ii = 1, iip1
      rlong(ii, jj) = rlonv(ii) * 180. / pi
      rlat(ii, jj) = rlatv(jj) * 180. / pi
    enddo
  enddo

  CALL histbeg(dynhistvave_file, iip1, rlong(:, 1), jjm, rlat(1, :), &
          1, iip1, 1, jjm, &
          tau0, zjulian, tstep, vhoriid, histvaveid)
  ! Grille U
  DO jj = 1, jjp1
    DO ii = 1, iip1
      rlong(ii, jj) = rlonu(ii) * 180. / pi
      rlat(ii, jj) = rlatu(jj) * 180. / pi
    enddo
  enddo

  CALL histbeg(dynhistuave_file, iip1, rlong(:, 1), jjp1, rlat(1, :), &
          1, iip1, 1, jjp1, &
          tau0, zjulian, tstep, uhoriid, histuaveid)

  !  Appel a histvert pour la grille verticale

  CALL histvert(histaveid, 'presnivs', 'Niveaux Pression approximatifs', 'mb', &
          llm, presnivs / 100., zvertiid, 'down')
  CALL histvert(histuaveid, 'presnivs', 'Niveaux Pression approximatifs', 'mb', &
          llm, presnivs / 100., zvertiid, 'down')
  CALL histvert(histvaveid, 'presnivs', 'Niveaux Pression approximatifs', 'mb', &
          llm, presnivs / 100., zvertiid, 'down')

  !  Appels a histdef pour la definition des variables a sauvegarder

  !  Vents U

  CALL histdef(histuaveid, 'u', 'vent u moyen ', &
          'm/s', iip1, jjp1, uhoriid, llm, 1, llm, zvertiid, &
          32, 'ave(X)', t_ops, t_wrt)

  !  Vents V

  CALL histdef(histvaveid, 'v', 'vent v moyen', &
          'm/s', iip1, jjm, vhoriid, llm, 1, llm, zvertiid, &
          32, 'ave(X)', t_ops, t_wrt)


  !  Temperature

  CALL histdef(histaveid, 'temp', 'temperature moyenne', 'K', &
          iip1, jjp1, thoriid, llm, 1, llm, zvertiid, &
          32, 'ave(X)', t_ops, t_wrt)

  !  Temperature potentielle

  CALL histdef(histaveid, 'theta', 'temperature potentielle', 'K', &
          iip1, jjp1, thoriid, llm, 1, llm, zvertiid, &
          32, 'ave(X)', t_ops, t_wrt)

  !  Geopotentiel

  CALL histdef(histaveid, 'phi', 'geopotentiel moyen', '-', &
          iip1, jjp1, thoriid, llm, 1, llm, zvertiid, &
          32, 'ave(X)', t_ops, t_wrt)

  !  Traceurs

  !        DO iq=1,nqtot
  !          CALL histdef(histaveid, tracers(iq)%name, &
  !                                  tracers(iq)%longName, '-',  &
  !                  iip1, jjp1, thoriid, llm, 1, llm, zvertiid, &
  !                  32, 'ave(X)', t_ops, t_wrt)
  !        enddo

  !  Masse

  CALL histdef(histaveid, 'masse', 'masse', 'kg', &
          iip1, jjp1, thoriid, llm, 1, llm, zvertiid, &
          32, 'ave(X)', t_ops, t_wrt)

  !  Pression au sol

  CALL histdef(histaveid, 'ps', 'pression naturelle au sol', 'Pa', &
          iip1, jjp1, thoriid, 1, 1, 1, -99, &
          32, 'ave(X)', t_ops, t_wrt)

  !  Geopotentiel au sol

  !      CALL histdef(histaveid, 'phis', 'geopotentiel au sol', '-', &
  !                  iip1, jjp1, thoriid, 1, 1, 1, -99, &
  !                  32, 'ave(X)', t_ops, t_wrt)

  CALL histend(histaveid)
  CALL histend(histuaveid)
  CALL histend(histvaveid)

END SUBROUTINE  initdynav
