! $Id: caladvtrac.F90 5182 2024-09-10 14:25:29Z abarral $



SUBROUTINE caladvtrac(q, pbaru, pbarv, &
        p, masse, dq, teta, &
        flxw, pk)

  USE lmdz_infotrac, ONLY: nqtot
  USE control_mod, ONLY: iapp_tracvl, planet_type
  USE comconst_mod, ONLY: dtvr
  USE lmdz_filtreg, ONLY: filtreg
  USE lmdz_ssum_scopy, ONLY: scopy

  USE lmdz_dimensions, ONLY: iim, jjm, llm, ndm
  USE lmdz_paramet
  IMPLICIT NONE

  ! Auteurs:   F.Hourdin , P.Le Van, F.Forget, F.Codron

  ! F.Codron (10/99) : ajout humidite specifique pour eau vapeur
  !=======================================================================

  !   Shema de  Van Leer

  !=======================================================================




  !   Arguments:
  !   ----------
  REAL :: pbaru(ip1jmp1, llm), pbarv(ip1jm, llm), masse(ip1jmp1, llm)
  REAL :: p(ip1jmp1, llmp1), q(ip1jmp1, llm, nqtot)
  REAL :: dq(ip1jmp1, llm, nqtot)
  REAL :: teta(ip1jmp1, llm), pk(ip1jmp1, llm)
  REAL :: flxw(ip1jmp1, llm)

  !  ..................................................................

  !  .. dq n'est utilise et dimensionne que pour l'eau  vapeur et liqu.

  !  ..................................................................

  !   Local:
  !   ------

  EXTERNAL  advtrac, minmaxq, qminimum
  INTEGER :: ij, l, iq, iapptrac
  REAL :: finmasse(ip1jmp1, llm), dtvrtrac

  !c

  ! Earth-specific stuff for the first 2 tracers (water)
  IF (planet_type=="earth") THEN
    ! initialisation
    ! CRisi: il faut gérer tous les traceurs si on veut pouvoir faire des
    ! isotopes
    ! dq(:,:,1:2)=q(:,:,1:2)
    dq(:, :, 1:nqtot) = q(:, :, 1:nqtot)

    !  test des valeurs minmax
    !c        CALL minmaxq(q(1,1,1),1.e33,-1.e33,'Eau vapeur (a) ')
    !c        CALL minmaxq(q(1,1,2),1.e33,-1.e33,'Eau liquide(a) ')
  ENDIF ! of if (planet_type.EQ."earth")
  !   advection

  CALL advtrac(pbaru, pbarv, &
          p, masse, q, iapptrac, teta, &
          flxw, pk)

  !

  IF(iapptrac==iapp_tracvl) THEN
    IF (planet_type=="earth") THEN
      ! Earth-specific treatment for the first 2 tracers (water)

      !c          CALL minmaxq(q(1,1,1),1.e33,-1.e33,'Eau vapeur     ')
      !c          CALL minmaxq(q(1,1,2),1.e33,-1.e33,'Eau liquide    ')

      !c     ....  Calcul  de deltap  qu'on stocke dans finmasse   ...

      DO l = 1, llm
        DO ij = 1, ip1jmp1
          finmasse(ij, l) = p(ij, l) - p(ij, l + 1)
        ENDDO
      ENDDO

      !WRITE(*,*) 'caladvtrac 87'
      CALL qminimum(q, nqtot, finmasse)
      !WRITE(*,*) 'caladvtrac 89'

      CALL SCOPY   (ip1jmp1 * llm, masse, 1, finmasse, 1)
      CALL filtreg (finmasse, jjp1, llm, -2, 2, .TRUE., 1)

      !   *****  Calcul de dq pour l'eau , pour le passer a la physique ******
      !   ********************************************************************

      dtvrtrac = iapp_tracvl * dtvr

      DO iq = 1, nqtot
        DO l = 1, llm
          DO ij = 1, ip1jmp1
            dq(ij, l, iq) = (q(ij, l, iq) - dq(ij, l, iq)) * finmasse(ij, l) &
                    / dtvrtrac
          ENDDO
        ENDDO
      ENDDO

    endif ! of if (planet_type.EQ."earth")
  ELSE
    IF (planet_type=="earth") THEN
      ! Earth-specific treatment for the first 2 tracers (water)
      dq(:, :, 1:nqtot) = 0.
    endif ! of if (planet_type.EQ."earth")
  ENDIF ! of IF( iapptrac.EQ.iapp_tracvl )

END SUBROUTINE caladvtrac


