module test_disvert_m

  USE lmdz_dimensions, ONLY: iim, jjm, llm, ndm
  IMPLICIT NONE

CONTAINS

  SUBROUTINE test_disvert

    ! Author: Lionel GUEZ

    ! This procedure tests the order of pressure values at half-levels
    ! and full levels. We arbitrarily choose to test ngrid values of
    ! the surface pressure, which sample possible values on Earth.

    USE exner_hyb_m, ONLY: exner_hyb
    USE lmdz_vertical_layers, ONLY: ap,bp,preff
    USE comconst_mod, ONLY: kappa, cpp
    USE lmdz_abort_physic, ONLY: abort_physic

    ! For llm:


    ! Local:
    INTEGER l, i
    INTEGER, parameter:: ngrid = 7
    REAL p(ngrid, llm + 1) ! pressure at half-level, in Pa
    REAL pks(ngrid) ! exner function at the surface, in J K-1 kg-1
    REAL pk(ngrid, llm) ! exner function at full level, in J K-1 kg-1
    REAL ps(ngrid) ! surface pressure, in Pa
    REAL p_lay(ngrid, llm) ! pressure at full level, in Pa
    REAL delta_ps ! in Pa

    !---------------------

    PRINT *, "Call sequence information: test_disvert"

    delta_ps = 6e4 / (ngrid - 1)
    ps = (/(5e4 + delta_ps * i, i = 0, ngrid - 1)/)
    forall (l = 1: llm + 1) p(:, l) = ap(l) + bp(l) * ps
    CALL exner_hyb(ngrid, ps, p, pks, pk)
    p_lay = preff * (pk / cpp)**(1. / kappa)

    ! Are pressure values in the right order?
    IF (any(p(:, :llm) <= p_lay .OR. p_lay <= p(:, 2:))) THEN
       ! List details and stop:
       DO l = 1, llm
          DO i = 1, ngrid
             IF (p(i, l) <= p_lay(i, l)) THEN
                print 1000, "ps = ", ps(i) / 100., "hPa, p(level ",  l, &
                     ") = ", p(i, l) / 100., " hPa <= p(layer ", l, ") = ", &
                     p_lay(i, l) / 100., " hPa"
             end if
             IF (p_lay(i, l) <= p(i, l + 1)) THEN
                print 1000, "ps = ", ps(i) / 100., "hPa, p(layer ", l, ") = ", &
                     p_lay(i, l) / 100., " hPa <= p(level ", l + 1, ") = ", &
                     p(i, l + 1) / 100., " hPa"
             end if
          END DO
       END DO
       CALL abort_physic("test_disvert", "bad order of pressure values", 1)
    end if

1000 format (3(a, g10.4, a, i0))

  END SUBROUTINE  test_disvert

END MODULE test_disvert_m
