MODULE lmdz_sisvat_weq
  IMPLICIT NONE; PRIVATE
  PUBLIC sisvat_weq

  LOGICAL :: logWEq

CONTAINS

  SUBROUTINE SISVAT_wEq(labWEq, istart)

    ! +------------------------------------------------------------------------+
    ! | MAR          SISVAT_wEq                                22-09-2001  MAR |
    ! |   SubRoutine SISVAT_wEq computes the Snow/Ice  Water  Equivalent       |
    ! |                                                                        |
    ! |                                                                        |
    ! |   Preprocessing  Option: SISVAT IO (not always a standard preprocess.) |
    ! |   ^^^^^^^^^^^^^^^^^^^^^  ^^^^^^^^^                                     |
    ! |   FILE                 |      CONTENT                                  |
    ! |   ~~~~~~~~~~~~~~~~~~~~~+~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ |
    ! | # SISVAT_wEq.ve        | #ve: OUTPUT/Verification: Snow/Ice Water Eqv. |
    ! |                        |      unit 45, SubRoutine  SISVAT_wEq **ONLY** |
    ! +------------------------------------------------------------------------+

    ! +--Global Variables
    ! +  ================
    USE VARphy
    USE VAR_SV
    USE VARxSV

    IMPLICIT NONE

    CHARACTER(LEN = 6) :: labWEq
    INTEGER :: istart

    ! +--Local  Variables
    ! +  ================

    INTEGER :: ikl, isn
    REAL :: SnoWEQ, IceWEQ


    ! +--Switch Initialization
    ! +  =====================

    IF (.NOT.logWEq)                                              THEN
      logWEq = .TRUE.
      open(unit = 45, status = 'unknown', file = 'SISVAT_wEq.ve')
      rewind    45
    END IF


    ! +--Snow Water Equivalent
    ! +  =====================

    ikl = 1
    IF          (isnoSV(ikl)>iiceSV(ikl))                      THEN
      SnoWEQ = 0.
      DO isn = iiceSV(ikl) + 1, isnoSV(ikl)
        SnoWEQ = SnoWEQ + ro__SV(ikl, isn) * dzsnSV(ikl, isn)
      END DO

    END IF


    ! +--Ice  Water Equivalent
    ! +  =====================
    IF        (iiceSV(1)>0)                                    THEN
      IceWEQ = 0.
      DO isn = 1, iiceSV(ikl)
        IceWEQ = IceWEQ + ro__SV(ikl, isn) * dzsnSV(ikl, isn)
      END DO

    END IF

  END SUBROUTINE sisvat_weq

END MODULE lmdz_sisvat_weq
