!
! $Id: readaerosolstrato_ecrad.F90 tlurton $
!
SUBROUTINE readaerosolstrato_ecrad(config, debut, ok_volcan)

    USE netcdf95, ONLY: nf95_close, nf95_gw_var, nf95_inq_dimid, & 
                        nf95_inq_varid, nf95_open
    USE netcdf, ONLY: nf90_get_var, nf90_noerr, nf90_nowrite

    USE phys_cal_mod, ONLY : mth_cur
    USE lmdz_grid_phy, ONLY: nbp_lon, nbp_lat, klon_glo, grid2dTo1d_glo, grid_type, unstructured
    USE lmdz_phys_mpi_data
    USE lmdz_phys_omp_data
    USE lmdz_phys_para
    USE phys_state_var_mod
    USE phys_local_var_mod
!    USE physiq_mod, ONLY : ok_volcan
    USE aero_mod
    USE dimphy
!    USE YOERAD
    USE radiation_config, ONLY : config_type
    USE YOMCST
    USE lmdz_abort_physic, ONLY: abort_physic
#ifdef CPP_XIOS
    USE xios
#endif
  USE lmdz_clesphys

    IMPLICIT NONE

    CHARACTER (len = 80) :: abort_message
    CHARACTER (LEN=20) :: modname = 'readaerosolstrato_ecrad'

! Variable input
    LOGICAL, INTENT(IN) ::  debut
    LOGICAL, INTENT(IN) ::  ok_volcan !activate volcanic diags

! Variables locales
    INTEGER n_lat   ! number of latitudes in the input data
    INTEGER n_lon   ! number of longitudes
    INTEGER n_lev   ! number of levels in the input data
    INTEGER n_month ! number of months in the input data
    INTEGER n_wav   ! number of wavelengths in the input data
    REAL, ALLOCATABLE:: latitude(:)
    REAL, ALLOCATABLE:: time(:)
    REAL, ALLOCATABLE:: lev(:)
    REAL, ALLOCATABLE:: wav(:)
    INTEGER i,k,wave,band
    INTEGER, SAVE :: mth_pre=1
!$OMP THREADPRIVATE(mth_pre)

    REAL, ALLOCATABLE, DIMENSION(:,:,:), SAVE :: tau_aer_strat
    REAL, ALLOCATABLE, DIMENSION(:,:,:), SAVE :: piz_aer_strat
    REAL, ALLOCATABLE, DIMENSION(:,:,:), SAVE :: cg_aer_strat
    REAL, ALLOCATABLE, DIMENSION(:,:,:), SAVE :: taulw_aer_strat
! add ThL
    REAL, ALLOCATABLE, DIMENSION(:,:,:), SAVE :: pizlw_aer_strat
    REAL, ALLOCATABLE, DIMENSION(:,:,:), SAVE :: cglw_aer_strat
! end add ThL
! mod ThL
!$OMP THREADPRIVATE(tau_aer_strat,piz_aer_strat,cg_aer_strat,taulw_aer_strat,pizlw_aer_strat,cglw_aer_strat)
! end mod ThL

! Champs reconstitues
    REAL, ALLOCATABLE:: tauaerstrat(:, :, :, :)
    REAL, ALLOCATABLE:: pizaerstrat(:, :, :, :)
    REAL, ALLOCATABLE:: cgaerstrat(:, :, :, :)
    REAL, ALLOCATABLE:: taulwaerstrat(:, :, :, :)
! add ThL
    REAL, ALLOCATABLE:: pizlwaerstrat(:, :, :, :)
    REAL, ALLOCATABLE:: cglwaerstrat(:, :, :, :)
! end add ThL

    REAL, ALLOCATABLE:: tauaerstrat_mois(:, :, :, :)
    REAL, ALLOCATABLE:: pizaerstrat_mois(:, :, :, :)
    REAL, ALLOCATABLE:: cgaerstrat_mois(:, :, :, :)
    REAL, ALLOCATABLE:: taulwaerstrat_mois(:, :, :, :)
! add ThL
    REAL, ALLOCATABLE:: pizlwaerstrat_mois(:, :, :, :)
    REAL, ALLOCATABLE:: cglwaerstrat_mois(:, :, :, :)
! end add ThL

    REAL, ALLOCATABLE:: tauaerstrat_mois_glo(:, :, :)
    REAL, ALLOCATABLE:: pizaerstrat_mois_glo(:, :, :)
    REAL, ALLOCATABLE:: cgaerstrat_mois_glo(:, :, :)
    REAL, ALLOCATABLE:: taulwaerstrat_mois_glo(:, :, :)
! add ThL
    REAL, ALLOCATABLE:: pizlwaerstrat_mois_glo(:, :, :)
    REAL, ALLOCATABLE:: cglwaerstrat_mois_glo(:, :, :) 
! end add ThL
    REAL, ALLOCATABLE:: tauaerstrat_mpi(:, :, :)
    REAL, ALLOCATABLE:: pizaerstrat_mpi(:, :, :)
    REAL, ALLOCATABLE:: cgaerstrat_mpi(:, :, :)
    REAL, ALLOCATABLE:: taulwaerstrat_mpi(:, :, :)
! add ThL
    REAL, ALLOCATABLE:: pizlwaerstrat_mpi(:, :, :)
    REAL, ALLOCATABLE:: cglwaerstrat_mpi(:, :, :)
! end add ThL

! For NetCDF:
    INTEGER ncid_in  ! IDs for input files
    INTEGER varid, ncerr

    TYPE(config_type), INTENT(IN) :: config

!--------------------------------------------------------

    IF (.not.ALLOCATED(tau_aer_strat)) ALLOCATE(tau_aer_strat(klon,klev,config%n_bands_sw))
    IF (.not.ALLOCATED(piz_aer_strat)) ALLOCATE(piz_aer_strat(klon,klev,config%n_bands_sw))
    IF (.not.ALLOCATED(cg_aer_strat))  ALLOCATE(cg_aer_strat(klon,klev,config%n_bands_sw))

    IF (.not.ALLOCATED(taulw_aer_strat)) ALLOCATE(taulw_aer_strat(klon,klev,config%n_bands_lw))
! add ThL    
    IF (.not.ALLOCATED(pizlw_aer_strat)) ALLOCATE(pizlw_aer_strat(klon,klev,config%n_bands_lw))
    IF (.not.ALLOCATED(cglw_aer_strat)) ALLOCATE(cglw_aer_strat(klon,klev,config%n_bands_lw))
! end add ThL

!--we only read monthly strat aerosol data
    IF (debut.OR.mth_cur.NE.mth_pre) THEN

!--only root reads the data
      IF (is_mpi_root.AND.is_omp_root) THEN

!--check mth_cur
        IF (mth_cur.LT.1.OR.mth_cur.GT.12) THEN
          print *,'probleme avec le mois dans readaerosolstrat =', mth_cur
        ENDIF

!--initialize n_lon as input data is 2D (lat-alt) only
        n_lon = nbp_lon

!--Starts with SW optical properties

        CALL nf95_open("tauswstrat.2D.nc", nf90_nowrite, ncid_in)

        CALL nf95_inq_varid(ncid_in, "LEV", varid)
        CALL nf95_gw_var(ncid_in, varid, lev)
        n_lev = size(lev)
        IF (n_lev.NE.klev) THEN 
           abort_message='Le nombre de niveaux n est pas egal a klev'
           CALL abort_physic(modname,abort_message,1)
        ENDIF

        CALL nf95_inq_varid(ncid_in, "LAT", varid)
        CALL nf95_gw_var(ncid_in, varid, latitude)
        n_lat = size(latitude)

        IF (grid_type/=unstructured) THEN
           IF (n_lat.NE.nbp_lat) THEN 
             print *, 'latitude=', n_lat, nbp_lat
             abort_message='Le nombre de lat n est pas egal a nbp_lat'
             CALL abort_physic(modname,abort_message,1)
           ENDIF
        ENDIF

        CALL nf95_inq_varid(ncid_in, "TIME", varid)
        CALL nf95_gw_var(ncid_in, varid, time)
        n_month = size(time)
        IF (n_month.NE.12) THEN 
           abort_message='Le nombre de month n est pas egal a 12'
           CALL abort_physic(modname,abort_message,1)
        ENDIF

        CALL nf95_inq_varid(ncid_in, "WAV", varid)
        CALL nf95_gw_var(ncid_in, varid, wav)
        n_wav = size(wav)
        print *, 'WAV aerosol strato=', n_wav, wav
!        IF (n_wav.NE.config%n_bands_sw) THEN 
!           abort_message='Le nombre de wav n est pas egal a config%n_bands_sw'
!           CALL abort_physic(modname,abort_message,1)
!        ENDIF

        ALLOCATE(tauaerstrat(n_lat, n_lev, n_wav, n_month))
        ALLOCATE(pizaerstrat(n_lat, n_lev, n_wav, n_month))
        ALLOCATE(cgaerstrat(n_lat, n_lev, n_wav, n_month))

!--reading stratospheric aerosol tau per layer
        CALL nf95_inq_varid(ncid_in, "TAU_SUN", varid)
        ncerr = nf90_get_var(ncid_in, varid, tauaerstrat)
        print *,'code erreur readaerosolstrato=', ncerr, varid

!--reading stratospheric aerosol omega per layer
        CALL nf95_inq_varid(ncid_in, "OME_SUN", varid)
        ncerr = nf90_get_var(ncid_in, varid, pizaerstrat)
        print *,'code erreur readaerosolstrato=', ncerr, varid

!--reading stratospheric aerosol g per layer
        CALL nf95_inq_varid(ncid_in, "GGG_SUN", varid)
        ncerr = nf90_get_var(ncid_in, varid, cgaerstrat)
        print *,'code erreur readaerosolstrato sw=', ncerr, varid

        CALL nf95_close(ncid_in)

       
        IF (grid_type/=unstructured) THEN
          ALLOCATE(tauaerstrat_mois(n_lon, n_lat, n_lev, n_wav))
          ALLOCATE(pizaerstrat_mois(n_lon, n_lat, n_lev, n_wav))
          ALLOCATE(cgaerstrat_mois(n_lon, n_lat, n_lev, n_wav))

          ALLOCATE(tauaerstrat_mois_glo(klon_glo, n_lev, n_wav))
          ALLOCATE(pizaerstrat_mois_glo(klon_glo, n_lev, n_wav))
          ALLOCATE(cgaerstrat_mois_glo(klon_glo, n_lev, n_wav))
!--select the correct month
!--and copy into 1st longitude
          tauaerstrat_mois(1,:,:,:) = tauaerstrat(:,:,:,mth_cur)
          pizaerstrat_mois(1,:,:,:) = pizaerstrat(:,:,:,mth_cur)
          cgaerstrat_mois(1,:,:,:)  = cgaerstrat(:,:,:,mth_cur)

!--copy longitudes
          DO i=2, n_lon
           tauaerstrat_mois(i,:,:,:) = tauaerstrat_mois(1,:,:,:)
           pizaerstrat_mois(i,:,:,:) = pizaerstrat_mois(1,:,:,:)
           cgaerstrat_mois(i,:,:,:)  = cgaerstrat_mois(1,:,:,:)
          ENDDO

!---reduce to a klon_glo grid 
          DO band=1, config%n_bands_sw
            CALL grid2dTo1d_glo(tauaerstrat_mois(:,:,:,band),tauaerstrat_mois_glo(:,:,band))
            CALL grid2dTo1d_glo(pizaerstrat_mois(:,:,:,band),pizaerstrat_mois_glo(:,:,band))
            CALL grid2dTo1d_glo(cgaerstrat_mois(:,:,:,band),cgaerstrat_mois_glo(:,:,band))
          ENDDO
        ENDIF
!--Now LW optical properties
!

        CALL nf95_open("taulwstrat.2D.nc", nf90_nowrite, ncid_in)

        CALL nf95_inq_varid(ncid_in, "LEV", varid)
        CALL nf95_gw_var(ncid_in, varid, lev)
        n_lev = size(lev)
        IF (n_lev.NE.klev) THEN 
           abort_message='Le nombre de niveaux n est pas egal a klev'
           CALL abort_physic(modname,abort_message,1)
        ENDIF

        CALL nf95_inq_varid(ncid_in, "LAT", varid)
        CALL nf95_gw_var(ncid_in, varid, latitude)
        n_lat = size(latitude)

        IF (grid_type/=unstructured) THEN
          IF (n_lat.NE.nbp_lat) THEN 
             abort_message='Le nombre de lat n est pas egal a nbp_lat'
             CALL abort_physic(modname,abort_message,1)
          ENDIF
        ENDIF
        
        CALL nf95_inq_varid(ncid_in, "TIME", varid)
        CALL nf95_gw_var(ncid_in, varid, time)
        n_month = size(time)
        IF (n_month.NE.12) THEN 
           abort_message='Le nombre de month n est pas egal a 12'
           CALL abort_physic(modname,abort_message,1)
        ENDIF

        CALL nf95_inq_varid(ncid_in, "WAV", varid)
        CALL nf95_gw_var(ncid_in, varid, wav)
        n_wav = size(wav)
        print *, 'WAV aerosol strato=', n_wav, wav
!        IF (n_wav.NE.config%n_bands_lw) THEN 
!           abort_message='Le nombre de wav n est pas egal a config%n_bands_lw'
!           CALL abort_physic(modname,abort_message,1)
!        ENDIF

        ALLOCATE(taulwaerstrat(n_lat, n_lev, n_wav, n_month))
! add ThL
        ALLOCATE(pizlwaerstrat(n_lat, n_lev, n_wav, n_month))
        ALLOCATE(cglwaerstrat(n_lat, n_lev, n_wav, n_month))
! end add ThL

!--reading stratospheric aerosol lw tau per layer
        CALL nf95_inq_varid(ncid_in, "TAU_EAR", varid)
        ncerr = nf90_get_var(ncid_in, varid, taulwaerstrat)
        print *,'code erreur readaerosolstrato lw=', ncerr, varid

! add/mod ThL
!--with ECRAd, we also read omega and g:
       !--reading stratospheric aerosol omega per layer
        CALL nf95_inq_varid(ncid_in, "OME_EAR", varid)
        ncerr = nf90_get_var(ncid_in, varid, pizlwaerstrat)
        print *,'code erreur readaerosolstrato lw=', ncerr, varid

!--reading stratospheric aerosol g per layer
        CALL nf95_inq_varid(ncid_in, "GGG_EAR", varid)
        ncerr = nf90_get_var(ncid_in, varid, cglwaerstrat)
        print *,'code erreur readaerosolstrato lw=', ncerr, varid

        CALL nf95_close(ncid_in)

        IF (grid_type/=unstructured) THEN

          ALLOCATE(taulwaerstrat_mois(n_lon, n_lat, n_lev, n_wav))
          ALLOCATE(pizlwaerstrat_mois(n_lon, n_lat, n_lev, n_wav))
          ALLOCATE(cglwaerstrat_mois(n_lon, n_lat, n_lev, n_wav))

          ALLOCATE(taulwaerstrat_mois_glo(klon_glo, n_lev, n_wav))
          ALLOCATE(pizlwaerstrat_mois_glo(klon_glo, n_lev, n_wav))
          ALLOCATE(cglwaerstrat_mois_glo(klon_glo, n_lev, n_wav))
!--select the correct month
!--and copy into 1st longitude
          taulwaerstrat_mois(1,:,:,:) = taulwaerstrat(:,:,:,mth_cur)
          pizlwaerstrat_mois(1,:,:,:) = pizlwaerstrat(:,:,:,mth_cur)
          cglwaerstrat_mois(1,:,:,:) = cglwaerstrat(:,:,:,mth_cur)
!--copy longitudes
          DO i=2, n_lon
            taulwaerstrat_mois(i,:,:,:) = taulwaerstrat_mois(1,:,:,:)
            pizlwaerstrat_mois(i,:,:,:) = pizlwaerstrat_mois(1,:,:,:)
            cglwaerstrat_mois(i,:,:,:) = cglwaerstrat_mois(1,:,:,:)
          ENDDO

!---reduce to a klon_glo grid 
          DO band=1, config%n_bands_lw
            CALL grid2dTo1d_glo(taulwaerstrat_mois(:,:,:,band),taulwaerstrat_mois_glo(:,:,band))
            CALL grid2dTo1d_glo(pizlwaerstrat_mois(:,:,:,band),pizlwaerstrat_mois_glo(:,:,band))
            CALL grid2dTo1d_glo(cglwaerstrat_mois(:,:,:,band),cglwaerstrat_mois_glo(:,:,band))
          ENDDO
        ENDIF
      
      ELSE !--proc other than mpi_root and omp_root
           !--dummy allocation needed for debug mode

        ALLOCATE(tauaerstrat_mois_glo(1,1,1))
        ALLOCATE(pizaerstrat_mois_glo(1,1,1))
        ALLOCATE(cgaerstrat_mois_glo(1,1,1))
        ALLOCATE(taulwaerstrat_mois_glo(1,1,1))
        ALLOCATE(pizlwaerstrat_mois_glo(1,1,1))
        ALLOCATE(cglwaerstrat_mois_glo(1,1,1))

        ALLOCATE(tauaerstrat(0,0,0,12))
        ALLOCATE(pizaerstrat(0,0,0,12))
        ALLOCATE(cgaerstrat(0,0,0,12))
        ALLOCATE(taulwaerstrat(0,0,0,12))
        ALLOCATE(pizlwaerstrat(0,0,0,12))
        ALLOCATE(cglwaerstrat(0,0,0,12))
! end add/mod ThL

      ENDIF !--is_mpi_root and is_omp_root

!$OMP BARRIER

!--keep memory of previous month
      mth_pre=mth_cur

      IF (grid_type==unstructured) THEN

#ifdef CPP_XIOS

        IF (is_omp_master) THEN
          ALLOCATE(tauaerstrat_mpi(klon_mpi, klev, config%n_bands_sw))
          ALLOCATE(pizaerstrat_mpi(klon_mpi, klev, config%n_bands_sw))
          ALLOCATE(cgaerstrat_mpi(klon_mpi, klev, config%n_bands_sw))        
          ALLOCATE(taulwaerstrat_mpi(klon_mpi, klev, config%n_bands_lw))
! add ThL
          ALLOCATE(pizlwaerstrat_mpi(klon_mpi, klev, config%n_bands_lw))
          ALLOCATE(cglwaerstrat_mpi(klon_mpi, klev, config%n_bands_lw))
! end add ThL

          CALL xios_send_field("tauaerstrat_in",SPREAD(tauaerstrat(:,:,:,mth_cur),1,8))
          CALL xios_recv_field("tauaerstrat_out",tauaerstrat_mpi)
          CALL xios_send_field("pizaerstrat_in",SPREAD(pizaerstrat(:,:,:,mth_cur),1,8))
          CALL xios_recv_field("pizaerstrat_out",pizaerstrat_mpi)
          CALL xios_send_field("cgaerstrat_in",SPREAD(cgaerstrat(:,:,:,mth_cur),1,8))
          CALL xios_recv_field("cgaerstrat_out",cgaerstrat_mpi)
          CALL xios_send_field("taulwaerstrat_in",SPREAD(taulwaerstrat(:,:,:,mth_cur),1,8))
          CALL xios_recv_field("taulwaerstrat_out",taulwaerstrat_mpi)
! add ThL
          CALL xios_send_field("pizlwaerstrat_in",SPREAD(pizlwaerstrat(:,:,:,mth_cur),1,8))
          CALL xios_recv_field("pizlwaerstrat_out",pizlwaerstrat_mpi)
          CALL xios_send_field("cglwaerstrat_in",SPREAD(cglwaerstrat(:,:,:,mth_cur),1,8))
          CALL xios_recv_field("cglwaerstrat_out",cglwaerstrat_mpi)
! end add ThL
        ELSE
          ALLOCATE(tauaerstrat_mpi(0, 0, 0))
          ALLOCATE(pizaerstrat_mpi(0, 0, 0))
          ALLOCATE(cgaerstrat_mpi(0, 0, 0))        
          ALLOCATE(taulwaerstrat_mpi(0, 0, 0))
! add ThL
          ALLOCATE(pizlwaerstrat_mpi(0, 0, 0))
          ALLOCATE(cglwaerstrat_mpi(0, 0, 0))
! end add ThL
        ENDIF  
        
        CALL scatter_omp(tauaerstrat_mpi,tau_aer_strat)
        CALL scatter_omp(pizaerstrat_mpi,piz_aer_strat)
        CALL scatter_omp(cgaerstrat_mpi,cg_aer_strat)
        CALL scatter_omp(taulwaerstrat_mpi,taulw_aer_strat)
! add ThL
        CALL scatter_omp(pizlwaerstrat_mpi,pizlw_aer_strat)
        CALL scatter_omp(cglwaerstrat_mpi,cglw_aer_strat)
! end add ThL
#endif
      ELSE  
        
!--scatter on all proc
        CALL scatter(tauaerstrat_mois_glo,tau_aer_strat)
        CALL scatter(pizaerstrat_mois_glo,piz_aer_strat)
        CALL scatter(cgaerstrat_mois_glo,cg_aer_strat)
        CALL scatter(taulwaerstrat_mois_glo,taulw_aer_strat)
! add ThL
        CALL scatter(pizlwaerstrat_mois_glo,pizlw_aer_strat)
        CALL scatter(cglwaerstrat_mois_glo,cglw_aer_strat) 
! end add ThL
        IF (is_mpi_root.AND.is_omp_root)  DEALLOCATE(tauaerstrat_mois, pizaerstrat_mois, cgaerstrat_mois, taulwaerstrat_mois, pizlwaerstrat_mois, cglwaerstrat_mois) ! mod ThL

      ENDIF 

      IF (is_mpi_root.AND.is_omp_root) THEN
        DEALLOCATE(tauaerstrat, pizaerstrat, cgaerstrat, taulwaerstrat, pizlwaerstrat, cglwaerstrat) ! mod ThL
      ENDIF
      

!$OMP BARRIER

    ENDIF !--debut ou nouveau mois

!--total vertical aod at the SW wavelengths
!--for now use ECRAD band #10 AOD into all wavelengths
!--it is only a reasonable approximation for 550 nm
!--WAV(10)=0.53 µm
!--<!!!> This is considering that wavebands are in their original order,
!--and have NOT been re-ordered monotonously, i.e. with
!--WAV(1) = 3.46 µm
!--WAV(2) = 2.79 µm
!--(...)
!--WAV(last-1) = 0.23 µm
!--WAV(last)= 8.02 µm
!--If bands were to be re-ordered, i.e. last band be put in 1st position,
!--then we should consider band=11 to fetch WAV=0.53 µm.
    band=10
    DO i=1, klon
    DO k=1, klev
      IF (stratomask(i,k).GT.0.999999) THEN
        DO wave=1, config%n_bands_sw
          tausum_aero(i,wave,id_STRAT_phy)=tausum_aero(i,wave,id_STRAT_phy)+tau_aer_strat(i,k,band)
        ENDDO
      ENDIF
    ENDDO
    ENDDO

    IF (.NOT. ok_volcan) THEN
!
!--this is the default case 
!--stratospheric aerosols are added to both index 2 and 1 for double radiation calls
!--weighted average for cg, piz and tau, adding strat aerosols on top of tropospheric ones
    DO band=1, config%n_bands_sw
      WHERE (stratomask.GT.0.999999)
!--strat aerosols are added to index 2: natural and anthropogenic aerosols for bands 1 to config%n_bands_sw 
        cg_aero_sw_rrtm(:,:,2,band)  = ( cg_aero_sw_rrtm(:,:,2,band)*piz_aero_sw_rrtm(:,:,2,band)*tau_aero_sw_rrtm(:,:,2,band) + &
                                         cg_aer_strat(:,:,band)*piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band) ) /              &
                                    MAX( piz_aero_sw_rrtm(:,:,2,band)*tau_aero_sw_rrtm(:,:,2,band) +                             &
                                         piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band), 1.e-15 )
        piz_aero_sw_rrtm(:,:,2,band) = ( piz_aero_sw_rrtm(:,:,2,band)*tau_aero_sw_rrtm(:,:,2,band) +                             &
                                         piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band) ) /                                     &
                                    MAX( tau_aero_sw_rrtm(:,:,2,band) + tau_aer_strat(:,:,band), 1.e-15 )
        tau_aero_sw_rrtm(:,:,2,band)  = tau_aero_sw_rrtm(:,:,2,band) + tau_aer_strat(:,:,band)
!--strat aerosols are added to index 1: natural aerosols only for bands 1 to config%n_bands_sw
        cg_aero_sw_rrtm(:,:,1,band)  = ( cg_aero_sw_rrtm(:,:,1,band)*piz_aero_sw_rrtm(:,:,1,band)*tau_aero_sw_rrtm(:,:,1,band) + &
                                         cg_aer_strat(:,:,band)*piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band) ) /              &
                                    MAX( piz_aero_sw_rrtm(:,:,1,band)*tau_aero_sw_rrtm(:,:,1,band) +                             &
                                         piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band), 1.e-15 )
        piz_aero_sw_rrtm(:,:,1,band) = ( piz_aero_sw_rrtm(:,:,1,band)*tau_aero_sw_rrtm(:,:,1,band) +                             &
                                         piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band) ) /                                     &
                                    MAX( tau_aero_sw_rrtm(:,:,1,band) + tau_aer_strat(:,:,band), 1.e-15 )
        tau_aero_sw_rrtm(:,:,1,band)  = tau_aero_sw_rrtm(:,:,1,band) + tau_aer_strat(:,:,band)
    ENDWHERE
    ENDDO
!
    ELSE
!
!--this is the VOLMIP case
!--stratospheric aerosols are only added to index 2 in this case 
!--weighted average for cg, piz and tau, adding strat aerosols on top of tropospheric ones
    DO band=1, config%n_bands_sw
      WHERE (stratomask.GT.0.999999)
!--strat aerosols are added to index 2 : natural and anthropogenic aerosols for bands 1 to config%n_bands_sw 
        cg_aero_sw_rrtm(:,:,2,band)  = ( cg_aero_sw_rrtm(:,:,2,band)*piz_aero_sw_rrtm(:,:,2,band)*tau_aero_sw_rrtm(:,:,2,band) + &
                                         cg_aer_strat(:,:,band)*piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band) ) /              &
                                    MAX( piz_aero_sw_rrtm(:,:,2,band)*tau_aero_sw_rrtm(:,:,2,band) +                             &
                                         piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band), 1.e-15 )
        piz_aero_sw_rrtm(:,:,2,band) = ( piz_aero_sw_rrtm(:,:,2,band)*tau_aero_sw_rrtm(:,:,2,band) +                             &
                                         piz_aer_strat(:,:,band)*tau_aer_strat(:,:,band) ) /                                     &
                                    MAX( tau_aero_sw_rrtm(:,:,2,band) + tau_aer_strat(:,:,band), 1.e-15 )
        tau_aero_sw_rrtm(:,:,2,band)  = tau_aero_sw_rrtm(:,:,2,band) + tau_aer_strat(:,:,band)
     ENDWHERE
  ENDDO
  ENDIF

!--total vertical aod at 10 um
!--this is approximated from band 7 of ECRAD (9.73 µm)
    band=7
    DO i=1, klon
    DO k=1, klev
      IF (stratomask(i,k).GT.0.999999) THEN
        DO wave=1, config%n_bands_lw
          tausum_aero(i,config%n_bands_sw+wave,id_STRAT_phy)=tausum_aero(i,config%n_bands_sw+wave,id_STRAT_phy)+taulw_aer_strat(i,k,band)
        ENDDO
      ENDIF
    ENDDO
    ENDDO

    IF (.NOT. ok_volcan) THEN
!--this is the default case 
!--stratospheric aerosols are added to both index 2 and 1
    DO band=1, config%n_bands_lw
      WHERE (stratomask.GT.0.999999)
! add ThL
        cg_aero_lw_rrtm(:,:,2,band)  = ( cg_aero_lw_rrtm(:,:,2,band)*piz_aero_lw_rrtm(:,:,2,band)*tau_aero_lw_rrtm(:,:,2,band) + &
                                         cglw_aer_strat(:,:,band)*pizlw_aer_strat(:,:,band)*taulw_aer_strat(:,:,band) ) /        &
                                    MAX( piz_aero_lw_rrtm(:,:,2,band)*tau_aero_lw_rrtm(:,:,2,band) +                             &
                                         pizlw_aer_strat(:,:,band)*taulw_aer_strat(:,:,band), 1.e-15 )
        piz_aero_lw_rrtm(:,:,2,band) = ( piz_aero_lw_rrtm(:,:,2,band)*tau_aero_lw_rrtm(:,:,2,band) +                             &
                                         pizlw_aer_strat(:,:,band)*taulw_aer_strat(:,:,band) ) /                                 &
                                    MAX( tau_aero_lw_rrtm(:,:,2,band) + taulw_aer_strat(:,:,band), 1.e-15 )
        cg_aero_lw_rrtm(:,:,1,band)  = ( cg_aero_lw_rrtm(:,:,1,band)*piz_aero_lw_rrtm(:,:,1,band)*tau_aero_lw_rrtm(:,:,1,band) + &
                                         cglw_aer_strat(:,:,band)*pizlw_aer_strat(:,:,band)*taulw_aer_strat(:,:,band) ) /        &
                                    MAX( piz_aero_lw_rrtm(:,:,1,band)*tau_aero_lw_rrtm(:,:,1,band) +                             &
                                         pizlw_aer_strat(:,:,band)*taulw_aer_strat(:,:,band), 1.e-15 )
        piz_aero_lw_rrtm(:,:,1,band) = ( piz_aero_lw_rrtm(:,:,1,band)*tau_aero_lw_rrtm(:,:,1,band) +                             &
                                         pizlw_aer_strat(:,:,band)*taulw_aer_strat(:,:,band) ) /                                 &
                                    MAX( tau_aero_lw_rrtm(:,:,1,band) + taulw_aer_strat(:,:,band), 1.e-15 )
! end add ThL
        tau_aero_lw_rrtm(:,:,2,band)  = tau_aero_lw_rrtm(:,:,2,band) + taulw_aer_strat(:,:,band)
        tau_aero_lw_rrtm(:,:,1,band)  = tau_aero_lw_rrtm(:,:,1,band) + taulw_aer_strat(:,:,band)
      ENDWHERE
    ENDDO
!
    ELSE
!
! mod ThL
!--this is the VOLMIP case
    DO band=1, config%n_bands_lw
      WHERE (stratomask.GT.0.999999)
!--stratospheric aerosols are not added to index 1 
!--and we copy index 2 in index 1 because we want the same dust aerosol LW properties as above
        cg_aero_lw_rrtm(:,:,1,band)  = cg_aero_lw_rrtm(:,:,2,band)
        piz_aero_lw_rrtm(:,:,1,band) = piz_aero_lw_rrtm(:,:,2,band)
        tau_aero_lw_rrtm(:,:,1,band) = tau_aero_lw_rrtm(:,:,2,band)

!--stratospheric aerosols are only added to index 2
        cg_aero_lw_rrtm(:,:,2,band)  = (cg_aero_lw_rrtm(:,:,2,band)*piz_aero_lw_rrtm(:,:,2,band)*tau_aero_lw_rrtm(:,:,2,band) + &
                                        cglw_aer_strat(:,:,band)*pizlw_aer_strat(:,:,band)*taulw_aer_strat(:,:,band)) /         &
                                        MAX( piz_aero_lw_rrtm(:,:,2,band)*tau_aero_lw_rrtm(:,:,2,band) +                        &
                                        pizlw_aer_strat(:,:,band)*taulw_aer_strat(:,:,band), 1.e-15 )
        piz_aero_lw_rrtm(:,:,2,band) = (piz_aero_lw_rrtm(:,:,2,band)*tau_aero_lw_rrtm(:,:,2,band) +                             &
                                        pizlw_aer_strat(:,:,band)*taulw_aer_strat(:,:,band) ) /                                 &
                                        MAX( tau_aero_lw_rrtm(:,:,2,band) + taulw_aer_strat(:,:,band), 1.e-15 )
        tau_aero_lw_rrtm(:,:,2,band)  = tau_aero_lw_rrtm(:,:,2,band) + taulw_aer_strat(:,:,band)
      ENDWHERE
    ENDDO
    ENDIF
! end mod ThL

!--default SSA value if there is no aerosol
!--to avoid 0 values that seems to cause some problem to RRTM
    WHERE (tau_aero_sw_rrtm.LT.1.e-14)
      piz_aero_sw_rrtm = 1.0
    ENDWHERE

!--in principle this should not be necessary 
!--as these variables have min values already but just in case
!--put 1e-15 min value to both SW and LW AOD
    tau_aero_sw_rrtm = MAX(tau_aero_sw_rrtm,1.e-15)
    tau_aero_lw_rrtm = MAX(tau_aero_lw_rrtm,1.e-15)

END SUBROUTINE readaerosolstrato_ecrad
