MODULE lmdz_calcul_divers
  IMPLICIT NONE; PRIVATE
  PUBLIC calcul_divers

CONTAINS

  SUBROUTINE calcul_divers(itap, itapm1, un_jour)
    ! IM, 26.05.2023
    ! Ne pas modifier les IFs ci-dessous impliquant itapm1,
    ! autrement les resultats seront faux !!
    !
    ! On utilise MOD(itap - itapm1,NINT(mth_len*un_jour/phys_tstep)).EQ.1)
    ! pour detecter le debut de chaque mois lorsque l'on tourne par an.

    ! itap : nombre de pas de temps de la physique
    ! itapm1 : somme du nombre de pas de temps du/des mois precedent/s.
    ! (itap - itapm1) : nombre de pas de temps du mois courant
    USE dimphy, ONLY: klon
    USE phys_state_var_mod, ONLY: phys_tstep, ndayrain_mth, nday_rain, total_rain, rain_fall, snow_fall
    USE phys_local_var_mod, ONLY: t2m_min_mon, t2m_max_mon, zt2m_min_mon, zt2m_max_mon, zt2m
    USE phys_cal_mod, ONLY: mth_len

    IMPLICIT NONE

    INTEGER, INTENT(IN) :: itap
    INTEGER, INTENT(INOUT) :: itapm1
    REAL, INTENT(IN) :: un_jour

    INTEGER :: i

    ! Initialisations itapm1 du premier mois
    IF(itap==1) THEN
      itapm1 = 0
      !        PRINT*,'initialisation itap=1 itapm1 ',itapm1
    ENDIF

    ! Initialisation debut de mois
    IF(itap==itapm1 + 1) THEN
      ndayrain_mth(:) = 0.
      !        PRINT*,'Initialisation ndayrain_mth ',itap
    ENDIF

    ! Initialisation debut de chaque jour
    IF(MOD(itap, NINT(un_jour / phys_tstep))==1) THEN
      nday_rain(:) = 0.
      !       PRINT*,'initialisation mois suivants day_rain itap',itap
    ENDIF

    ! Calcul a chaque pas de temps de la physique
    DO i = 1, klon
      total_rain(i) = rain_fall(i) + snow_fall(i)
      IF(total_rain(i)>0.) nday_rain(i) = 1.
    ENDDO

    ! Cumul en fin de journee
    IF(MOD(itap, NINT(un_jour / phys_tstep))==0) THEN
      DO i = 1, klon
        ndayrain_mth(i) = ndayrain_mth(i) + nday_rain(i)
      ENDDO
    ENDIF

    ! Initialisation fin de mois
    ! Ne pas changer le IF ci-dessous, car le compteur itapm1 est augmente
    ! apres, dans la boucle !!!
    ! IM, 260523
    IF(MOD(itap - itapm1, NINT(mth_len * un_jour / phys_tstep))==0) THEN
      itapm1 = itapm1 + NINT(mth_len * un_jour / phys_tstep)
      !       PRINT*,'fmois i i1 mjt',itap,itapm1,mth_len,un_jour,phys_tstep
    ENDIF

    ! calcul temperatures minimale et maximale moyennees sur le mois

    !initialisation debut de mois pour les fichiers mensuels annuels
    IF(itap==itapm1 + 1) THEN
      t2m_min_mon = 0.
      t2m_max_mon = 0.
    ENDIF

    !initialisation debut de journee pour les fichiers mensuels annuels
    IF(MOD(itap, NINT(un_jour / phys_tstep))==1) THEN
      zt2m_min_mon = zt2m
      zt2m_max_mon = zt2m
    ENDIF

    !calcul sur tous les pas de temps pour les fichiers mensuels annuels
    DO i = 1, klon
      zt2m_min_mon(i) = MIN(zt2m(i), zt2m_min_mon(i))
      zt2m_max_mon(i) = MAX(zt2m(i), zt2m_max_mon(i))
    ENDDO

    !fin journee
    IF(MOD(itap, NINT(un_jour / phys_tstep))==0) THEN
      t2m_min_mon = t2m_min_mon + zt2m_min_mon
      t2m_max_mon = t2m_max_mon + zt2m_max_mon
    ENDIF

    !fin mois
    IF(itap==itapm1) THEN
      t2m_min_mon = t2m_min_mon / mth_len
      t2m_max_mon = t2m_max_mon / mth_len
    ENDIF

  END SUBROUTINE calcul_divers

END MODULE lmdz_calcul_divers