! $Id: dimphy.F90 5151 2024-07-31 15:24:31Z abarral $

MODULE dimphy
  
  IMPLICIT NONE; PRIVATE
  PUBLIC klon, kdlon, kfdia, kidia, klev, klevp1, klevm1, kflev, &
          init_dimphy, init_dimphy1D, zmasq

  INTEGER :: klon, kdlon, kfdia, kidia, klev, klevp1, klevm1, kflev

  !$OMP THREADPRIVATE(klon,kfdia,kidia,kdlon)
  REAL, ALLOCATABLE, DIMENSION(:) :: zmasq
  !$OMP THREADPRIVATE(zmasq)

CONTAINS

  SUBROUTINE init_dimphy(klon0, klev0)
    IMPLICIT NONE

    INTEGER, INTENT(IN) :: klon0, klev0

    klon = klon0
    kdlon = klon
    kidia = 1
    kfdia = klon
    !$OMP MASTER
    klev = klev0
    klevp1 = klev + 1
    klevm1 = klev - 1
    kflev = klev
    !$OMP END MASTER
    ALLOCATE(zmasq(klon))
    zmasq = 0.

  END SUBROUTINE init_dimphy

  SUBROUTINE init_dimphy1D(klon0, klev0)
    ! 1D special version of dimphy without ALLOCATE(zmasq)
    ! which will be allocated in iniphysiq
    IMPLICIT NONE

    INTEGER, INTENT(IN) :: klon0
    INTEGER, INTENT(IN) :: klev0

    klon = klon0
    kdlon = klon
    kidia = 1
    kfdia = klon
    klev = klev0
    klevp1 = klev + 1
    klevm1 = klev - 1
    kflev = klev

  END SUBROUTINE init_dimphy1D


END MODULE dimphy
