! $Header$

SUBROUTINE inigrads(if, im &
        , x, fx, xmin, xmax, jm, y, ymin, ymax, fy, lm, z, fz &
        , dt, file, titlel)
  USE lmdz_gradsdef

  IMPLICIT NONE

  INTEGER :: if, im, jm, lm, i, j, l
  REAL :: x(im), y(jm), z(lm), fx, fy, fz, dt
  REAL :: xmin, xmax, ymin, ymax

  CHARACTER(LEN = *), INTENT(IN) :: file
  CHARACTER(LEN = *), INTENT(IN) :: titlel

  ! data unit/66,32,34,36,38,40,42,44,46,48/
  INTEGER :: nf
  save nf
  data nf/0/

  unit(1) = 66
  unit(2) = 32
  unit(3) = 34
  unit(4) = 36
  unit(5) = 38
  unit(6) = 40
  unit(7) = 42
  unit(8) = 44
  unit(9) = 46

  IF (if<=nf) stop 'verifier les appels a inigrads'

  PRINT*, 'Entree dans inigrads'

  nf = if
  title(if) = titlel
  ivar(if) = 0

  fichier(if) = trim(file)

  firsttime(if) = .TRUE.
  dtime(if) = dt

  iid(if) = 1
  ifd(if) = im
  imd(if) = im
  do i = 1, im
    xd(i, if) = x(i) * fx
    IF(xd(i, if)<xmin) iid(if) = i + 1
    IF(xd(i, if)<=xmax) ifd(if) = i
  enddo
  PRINT*, 'On stoke du point ', iid(if), '  a ', ifd(if), ' en x'

  jid(if) = 1
  jfd(if) = jm
  jmd(if) = jm
  do j = 1, jm
    yd(j, if) = y(j) * fy
    IF(yd(j, if)>ymax) jid(if) = j + 1
    IF(yd(j, if)>=ymin) jfd(if) = j
  enddo
  PRINT*, 'On stoke du point ', jid(if), '  a ', jfd(if), ' en y'

  PRINT*, 'Open de dat'
  PRINT*, 'file=', file
  PRINT*, 'fichier(if)=', fichier(if)

  PRINT*, 4 * (ifd(if) - iid(if)) * (jfd(if) - jid(if))
  PRINT*, trim(file) // '.dat'

  OPEN (unit(if) + 1, FILE = trim(file) // '.dat' &
          , FORM = 'unformatted', &
          ACCESS = 'direct' &
          , RECL = 4 * (ifd(if) - iid(if) + 1) * (jfd(if) - jid(if) + 1))

  PRINT*, 'Open de dat ok'

  lmd(if) = lm
  do l = 1, lm
    zd(l, if) = z(l) * fz
  enddo

  irec(if) = 0

  PRINT*, if, imd(if), jmd(if), lmd(if)
  PRINT*, 'if,imd(if),jmd(if),lmd(if)'


END SUBROUTINE inigrads
