       SUBROUTINE read_surface(name,surfa)

     
! common
! ------
       USE ioipsl
       USE dimphy
       USE lmdz_grid_phy
       USE lmdz_phys_para
       USE iophy
       USE netcdf, ONLY:nf90_inq_varid,nf90_noerr,nf90_get_var,nf90_nowrite,nf90_inq_varid,nf90_open
       IMPLICIT NONE

       INCLUDE "dimensions.h"
       INCLUDE "paramet.h"

       CHARACTER*10 name
       CHARACTER*10 varname

       REAL tmp_dyn(iip1,jjp1)
       REAL tmp_dyn_glo(nbp_lon+1,nbp_lat)
       REAL tmp_dyn_invers(iip1,jjp1)
       REAL tmp_dyn_invers_glo(nbp_lon+1,nbp_lat)
       REAL tmp_fi(klon)
       REAL tmp_fi_glo(klon_glo)
       REAL surfa(klon,5)
       REAL surfa_glo(klon_glo,5)

       INTEGER ncid
       INTEGER varid
       INTEGER rcode
       INTEGER start(2),count(2),status
       INTEGER i,j,l,ig
       CHARACTER*1 str1

!JE20140526<<
      CHARACTER*4 ::  latstr,aux4s
      LOGICAL :: outcycle, isinversed
      REAL, DIMENSION(jjp1) :: lats
      REAL, DIMENSION(nbp_lat) :: lats_glo
      REAL :: rcode2
      INTEGER, DIMENSION(1) :: startj,endj
!JE20140526>>
!$OMP MASTER
       IF (is_mpi_root .AND. is_omp_root) THEN

       PRINT*,'Lecture du fichier donnees_lisa.nc'
       ncid=nf90_open('donnees_lisa.nc',nf90_nowrite,rcode)

!JE20140526<<: check if are inversed or not the latitude grid in donnes_lisa
      outcycle=.FALSE.
      latstr='null'
      isinversed=.FALSE.
      do i=1,5
       IF (i==1) aux4s='latu'
       IF (i==2) aux4s='LATU'
       IF (i==3) aux4s='LatU'
       IF (i==4) aux4s='Latu'
       IF (i==5) aux4s='latU'
       status = nf90_inq_varid (ncid, aux4s, rcode)
!       print *,'stat,i',status,i,outcycle,aux4s
!       print *,'ifclause',status.NE. nf90_noerr ,outcycle == .FALSE.
       IF ((.NOT.(status/= nf90_noerr) ).AND.( .NOT. outcycle )) THEN
         outcycle=.TRUE.
         latstr=aux4s
       ENDIF
      enddo ! check if it inversed lat
      startj(1)=1
!      endj(1)=jjp1
      endj(1)=nbp_lat
      varid=nf90_inq_varid(ncid,latstr,rcode)

          status=nf90_get_var(ncid,varid,lats_glo,startj,endj)
!      print *,latstr,varid,status,jjp1,rcode
!      IF (status .NE. nf90_noerr) PRINT*,'NOOOOOOO'
!      print *,lats
!stop

! check if netcdf is latitude inversed or not. 
      IF (lats_glo(1)<lats_glo(2)) isinversed=.TRUE.
! JE20140526>>


       DO i=1,5
          WRITE(str1,'(i1)') i
          varname=trim(name)//str1
       PRINT*,'lecture variable:',varname
          varid=nf90_inq_varid(ncid,trim(varname),rcode)

!  dimensions pour les champs scalaires et le vent zonal
!  -----------------------------------------------------

          start(1)=1
          start(2)=1      
          count(1)=nbp_lon+1
!          count(1)=iip1
          count(2)=nbp_lat
!          count(2)=jjp1

! mise a zero des tableaux 
! ------------------------
          tmp_dyn(:,:)=0.0
          tmp_fi(:)=0.0
! Lecture
! -----------------------
          status=nf90_get_var(ncid,varid,tmp_dyn_glo,start,count)

!      CALL dump2d(iip1,jjp1,tmp_dyn,'tmp_dyn   ')
       DO j=1, nbp_lat
          DO ig=1, nbp_lon+1
             tmp_dyn_invers_glo(ig,j)=tmp_dyn_glo(ig,nbp_lat-j+1)
          ENDDO
       ENDDO

       
!JE20140522!          CALL gr_dyn_fi_p(1, iip1, jjp1, klon, tmp_dyn_invers, tmp_fi)

!JE20140526<<
!              CALL gr_dyn_fi(1, iip1, jjp1, klon, tmp_dyn_invers, tmp_fi)
           IF (isinversed) THEN
                        CALL gr_dyn_fi(1, nbp_lon+1, nbp_lat, klon_glo, &
   tmp_dyn_invers_glo, tmp_fi_glo)
!              CALL gr_dyn_fi(1, iip1, jjp1, klon, tmp_dyn_invers, tmp_fi)
!              CALL gr_dyn_fi_p(1, iip1, jjp1, klon, tmp_dyn_invers, tmp_fi)
           else      
                        CALL gr_dyn_fi(1, nbp_lon+1, nbp_lat, klon_glo, &
     tmp_dyn_glo, tmp_fi_glo)
!              CALL gr_dyn_fi(1, iip1, jjp1, klon, tmp_dyn, tmp_fi)
!              CALL gr_dyn_fi_p(1, iip1, jjp1, klon, tmp_dyn, tmp_fi)
           endif
!JE20140526>>
!      CALL dump2d(iim,jjm-1,tmp_fi(2),'tmp_fi   ')

          DO j=1,klon_glo

                surfa_glo(j,i)=tmp_fi_glo(j)

          ENDDO ! Fin de recopie du tableau

       ENDDO ! Fin boucle 1 a 5
       PRINT*,'Passage Grille Dyn -> Phys'


      ENDIF !mpi 
!$OMP END MASTER
!$OMP BARRIER
      CALL scatter(surfa_glo,surfa)



       END SUBROUTINE  read_surface
