SUBROUTINE minmaxsource(zq, qmin, qmax, comment)

  USE dimphy
  USE infotrac
  USE lmdz_libmath, ONLY: ismax, ismin

  INCLUDE "dimensions.h"

  ! CHARACTER*20 comment
  CHARACTER(LEN = *) :: comment
  REAL :: qmin, qmax
  REAL :: zq(klon, nbtr)

  INTEGER :: ijmin, lmin, ijlmin
  INTEGER :: ijmax, lmax, ijlmax

  ijlmin = ismin(klon * nbtr, zq, 1)
  lmin = (ijlmin - 1) / klon + 1
  ijmin = ijlmin - (lmin - 1) * klon
  zqmin = zq(ijmin, lmin)

  ijlmax = ismax(klon * nbtr, zq, 1)
  lmax = (ijlmax - 1) / klon + 1
  ijmax = ijlmax - (lmax - 1) * klon
  zqmax = zq(ijmax, lmax)

  IF(zqmin<qmin.OR.zqmax>qmax) &
          WRITE(*, 9999) comment, &
                  ijmin, lmin, zqmin, ijmax, lmax, zqmax

  RETURN
  9999   format(a20, 2('  q(', i4, ',', i2, ')=', e12.5))
END SUBROUTINE minmaxsource
