
! $Id: mod_interface_dyn_phys.F90 5134 2024-07-26 15:56:37Z abarral $

MODULE mod_interface_dyn_phys
  INTEGER,SAVE,DIMENSION(:),ALLOCATABLE :: index_i
  INTEGER,SAVE,DIMENSION(:),ALLOCATABLE :: index_j
  
  
CONTAINS
  
#ifdef CPP_PARA
! Interface with parallel physics,
  SUBROUTINE Init_interface_dyn_phys
    USE lmdz_phys_mpi_data
    IMPLICIT NONE
    INCLUDE 'dimensions.h'
    
    INTEGER :: i,j,k
    
    ALLOCATE(index_i(klon_mpi))
    ALLOCATE(index_j(klon_mpi))
    
    k=1
    IF (is_north_pole_dyn) THEN
      index_i(k)=1
      index_j(k)=1
      k=2
    ELSE
      DO i=ii_begin,iim
        index_i(k)=i
        index_j(k)=jj_begin
        k=k+1
      ENDDO
    ENDIF
    
    DO j=jj_begin+1,jj_end-1
      DO i=1,iim
        index_i(k)=i
        index_j(k)=j
        k=k+1
      ENDDO
    ENDDO
    
    IF (is_south_pole_dyn) THEN
      index_i(k)=1
      index_j(k)=jj_end
    ELSE
      DO i=1,ii_end
        index_i(k)=i
        index_j(k)=jj_end
        k=k+1
       ENDDO
    ENDIF
  
  END SUBROUTINE Init_interface_dyn_phys 
#else
  SUBROUTINE Init_interface_dyn_phys
  ! dummy routine for seq case
  END SUBROUTINE Init_interface_dyn_phys 
#endif
! of #ifdef CPP_PARA
END MODULE mod_interface_dyn_phys
