! This module replaces grid/fxy_prim.h

MODULE lmdz_fxy_prim
  USE comconst_mod, ONLY: pi
  IMPLICIT NONE; PRIVATE
  PUBLIC fx, fxprim, fy, fyprim
  INCLUDE "dimensions.h"
CONTAINS

  REAL FUNCTION fx(ri)
    REAL, INTENT(IN) :: ri
    fx = 2. * pi / REAL(iim) * (ri - 0.5 * REAL(iim) - 1.)
  END FUNCTION fx

  REAL FUNCTION fxprim(ri)
    REAL, INTENT(IN) :: ri
    fxprim = 2. * pi / REAL(iim)
  END FUNCTION fxprim

  REAL FUNCTION fy(rj)
    REAL, INTENT(IN) :: rj
    fy = pi / REAL(jjm) * (0.5 * REAL(jjm) + 1. - rj)
  END FUNCTION fy

  REAL FUNCTION fyprim(rj)
    REAL, INTENT(IN) :: rj
    fyprim = pi / REAL(jjm)
  END FUNCTION fyprim
END MODULE lmdz_fxy_prim