SUBROUTINE convflu_loc( xflu,yflu,nbniv,convfl )
  !
  !  P. Le Van
  !
  !
  !    *******************************************************************
  !  ... calcule la (convergence horiz. * aire locale)du flux ayant pour
  !  composantes xflu et yflu ,variables extensives .  ......
  !    *******************************************************************
  !  xflu , yflu et nbniv sont des arguments d'entree pour le s-pg ..
  !  convfl                est  un argument de sortie pour le s-pg .
  !
  ! njxflu  est le nombre de lignes de latitude de xflu,
  ! ( = jjm ou jjp1 )
  ! nbniv   est le nombre de niveaux vert. de  xflu et de yflu .
  !
  USE parallel_lmdz
  USE lmdz_ssum_scopy, ONLY: ssum

  IMPLICIT NONE
  !
  INCLUDE "dimensions.h"
  INCLUDE "paramet.h"
  REAL :: xflu,yflu,convfl,convpn,convps
  INTEGER :: l,ij,nbniv
  DIMENSION  xflu( ijb_u:ije_u,nbniv ),yflu( ijb_v:ije_v,nbniv ) , &
        convfl( ijb_u:ije_u,nbniv )
  !
  INTEGER :: ijb,ije
  !
  !
  INCLUDE "comgeom.h"
  !

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l = 1,nbniv
  !
    ijb=ij_begin
    ije=ij_end+iip1

    IF (pole_nord) ijb=ij_begin+iip1
    IF (pole_sud)  ije=ij_end-iip1

    DO ij = ijb , ije - 1
      convfl(ij+1,l) = xflu(ij,l) - xflu(ij+ 1,l)   + &
            yflu(ij +1,l ) - yflu( ij -iim,l )
  END DO
  !
  !

  ! ....  correction pour  convfl( 1,j,l)  ......
  ! ....   convfl(1,j,l)= convfl(iip1,j,l) ...
  !
  !DIR$ IVDEP
    DO ij = ijb,ije,iip1
      convfl( ij,l ) = convfl( ij + iim,l )
  END DO
  !
  ! ......  calcul aux poles  .......
  !
    IF (pole_nord) THEN

      convpn =   SSUM( iim, yflu(     1    ,l ),  1 )

      DO ij = 1,iip1
        convfl(ij,l) = convpn * aire(ij) / apoln
      ENDDO

    ENDIF

    IF (pole_sud) THEN

      convps = - SSUM( iim, yflu( ip1jm-iim,l ),  1 )

      DO ij = 1,iip1
        convfl(ij+ip1jm,l) = convps * aire(ij+ ip1jm) / apols
      ENDDO

    ENDIF

  END DO
!$OMP END DO NOWAIT

END SUBROUTINE convflu_loc
