SUBROUTINE dudv2_loc( teta, pkf, bern, du, dv  )
  USE parallel_lmdz
  IMPLICIT NONE
  !
  !=======================================================================
  !
  !   Auteur:  P. Le Van
  !   -------
  !
  !   Objet:
  !   ------
  !
  !   *****************************************************************
  !   ..... calcul du terme de pression (gradient de p/densite )   et
  !      du terme de ( -gradient de la fonction de Bernouilli ) ...
  !   *****************************************************************
  !      Ces termes sont ajoutes a  d(ucov)/dt et a d(vcov)/dt  ..
  !
  !
  !    teta , pkf, bern  sont des arguments d'entree  pour le s-pg  ....
  !    du et dv          sont des arguments de sortie pour le s-pg  ....
  !
  !=======================================================================
  !
  include "dimensions.h"
  include "paramet.h"

  REAL :: teta( ijb_u:ije_u,llm ),pkf( ijb_u:ije_u,llm )
  REAL :: bern( ijb_u:ije_u,llm )
  REAL :: du( ijb_u:ije_u,llm ),  dv( ijb_v:ije_v,llm )
  INTEGER :: l,ij,ijb,ije
  !
  !
!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l = 1,llm
  !
  ijb=ij_begin
  ije=ij_end
  IF (pole_nord) ijb=ijb+iip1
  IF (pole_sud)  ije=ije-iip1

  DO ij  = ijb, ije - 1
   du(ij,l) = du(ij,l) + 0.5* ( teta( ij,l ) + teta( ij+1,l ) ) * &
         ( pkf( ij,l ) - pkf(ij+1,l) )  + bern(ij,l) - bern(ij+1,l)
  END DO
  !
  !
  !    .....  correction  pour du(iip1,j,l),  j=2,jjm   ......
  !    ...          du(iip1,j,l) = du(1,j,l)                 ...
  !
  !DIR$ IVDEP
  DO ij = ijb+iip1-1, ije, iip1
  du( ij,l ) = du( ij - iim,l )
  END DO
  !
  !
  IF (pole_nord) ijb=ijb-iip1

  DO ij  = ijb,ije
  dv( ij,l) = dv(ij,l) + 0.5 * ( teta(ij,l) + teta( ij+iip1,l ) ) * &
        ( pkf(ij+iip1,l) - pkf(  ij,l  ) ) &
        +   bern( ij+iip1,l ) - bern( ij  ,l )
  END DO
  !
  END DO
!$OMP END DO NOWAIT
  !

END SUBROUTINE dudv2_loc
