SUBROUTINE dudv1_loc( vorpot, pbaru, pbarv, du, dv )
  USE parallel_lmdz
  IMPLICIT NONE
  !
  !-----------------------------------------------------------------------
  !
  !   Auteur:   P. Le Van
  !   -------
  !
  !   Objet:
  !   ------
  !   calcul du terme de  rotation
  !   ce terme est ajoute a  d(ucov)/dt et a d(vcov)/dt  ..
  !   vorpot, pbaru et pbarv sont des arguments d'entree  pour le s-pg ..
  !   du  et dv              sont des arguments de sortie pour le s-pg ..
  !
  !-----------------------------------------------------------------------

  INCLUDE "dimensions.h"
  INCLUDE "paramet.h"

  REAL :: vorpot( ijb_v:ije_v,llm ) ,pbaru( ijb_u:ije_u,llm ) , &
        pbarv( ijb_v:ije_v,llm )
  REAL :: du( ijb_u:ije_u,llm ) ,dv( ijb_v:ije_v,llm )
  INTEGER :: l,ij,ijb,ije
  !
  !

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l = 1,llm
  !
  ijb=ij_begin
  ije=ij_end

  IF (pole_nord) ijb=ij_begin+iip1
  IF (pole_sud)  ije=ij_end-iip1

  DO ij = ijb, ije-1
  du( ij,l ) = 0.125 *(  vorpot(ij-iip1, l) + vorpot( ij, l)  ) * &
        (   pbarv(ij-iip1, l) + pbarv(ij-iim,  l) + &
        pbarv(   ij  , l) + pbarv(ij+ 1 ,  l)   )
  END DO


  !
  IF (pole_nord) ijb=ij_begin

  DO ij = ijb, ije-1
  dv( ij+1,l ) = - 0.125 *(  vorpot(ij, l)  + vorpot(ij+1, l)  ) * &
        (   pbaru(ij, l)  +  pbaru(ij+1   , l) + &
        pbaru(ij+iip1, l)  +  pbaru(ij+iip2, l)  )
  END DO
  !
  !    .... correction  pour  dv( 1,j,l )  .....
  !    ....   dv(1,j,l)= dv(iip1,j,l) ....
  !
  !DIR$ IVDEP
  DO ij = ijb, ije, iip1
  dv( ij,l ) = dv( ij + iim, l )
  END DO
  !
  END DO
!$OMP END DO NOWAIT

END SUBROUTINE dudv1_loc
