SUBROUTINE divergf_loc(klevel,x,y,div)
  !
  ! P. Le Van
  !
  !  *********************************************************************
  !  ... calcule la divergence a tous les niveaux d'1 vecteur de compos.
  ! x et y...
  !          x et y  etant des composantes covariantes   ...
  !  *********************************************************************
  USE parallel_lmdz
  USE lmdz_filtreg_p
  IMPLICIT NONE
  !
  !  x  et  y  sont des arguments  d'entree pour le s-prog
  !    div      est  un argument  de sortie pour le s-prog
  !
  !
  !   ---------------------------------------------------------------------
  !
  !    ATTENTION : pendant ce s-pg , ne pas toucher au COMMON/scratch/  .
  !
  !   ---------------------------------------------------------------------
  INCLUDE "dimensions.h"
  INCLUDE "paramet.h"
  INCLUDE "comgeom.h"
  !
  !    ..........          variables en arguments    ...................
  !
  INTEGER :: klevel
  REAL :: x( ijb_u:ije_u,klevel ),y( ijb_v:ije_v,klevel )
  REAL :: div( ijb_u:ije_u,klevel )
  INTEGER :: l,ij
  !
  !    ...............     variables  locales   .........................

  REAL :: aiy1( iip1 ) , aiy2( iip1 )
  REAL :: sumypn,sumyps
  !    ...................................................................
  !
  EXTERNAL  SSUM
  REAL :: SSUM
  INTEGER :: ijb,ije,jjb,jje
  !
  !
  ijb=ij_begin
  ije=ij_end
  IF (pole_nord) ijb=ij_begin+iip1
  IF(pole_sud)  ije=ij_end-iip1

!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
  DO l = 1,klevel
  !
    DO  ij = ijb, ije - 1
     div( ij + 1, l )     = &
           cvusurcu( ij+1 ) * x( ij+1,l ) - cvusurcu( ij ) * x( ij , l) + &
           cuvsurcv(ij-iim) * y(ij-iim,l) - cuvsurcv(ij+1) * y(ij+1,l)
    ENDDO

  !
  ! ....  correction pour  div( 1,j,l)  ......
  ! ....   div(1,j,l)= div(iip1,j,l) ....
  !
  !DIR$ IVDEP
    DO  ij = ijb,ije,iip1
     div( ij,l ) = div( ij + iim,l )
    ENDDO
  !
  ! ....  calcul  aux poles  .....
  !
    IF (pole_nord) THEN
      DO  ij  = 1,iim
       aiy1(ij) =    cuvsurcv(    ij       ) * y(     ij     , l )
      ENDDO
      sumypn = SSUM ( iim,aiy1,1 ) / apoln

  !
      DO  ij = 1,iip1
       div(     ij    , l ) = - sumypn
      ENDDO

    endif

    IF (pole_sud) THEN
      DO  ij  = 1,iim
       aiy2(ij) =    cuvsurcv( ij+ ip1jmi1 ) * y( ij+ ip1jmi1, l )
      ENDDO
      sumyps = SSUM ( iim,aiy2,1 ) / apols
  !
      DO  ij = 1,iip1
       div( ij + ip1jm, l ) =   sumyps
      ENDDO

    endif

  END DO
!$OMP END DO NOWAIT

  !
    jjb=jj_begin
    jje=jj_end
    IF (pole_sud) jje=jj_end-1

    CALL filtreg_p( div,jjb_u,jje_u,jjb,jje, jjp1, &
          klevel, 2, 2, .TRUE., 1 )

  !
!$OMP DO SCHEDULE(STATIC,OMP_CHUNK)
    DO l = 1, klevel
       DO ij = ijb,ije
        div(ij,l) = div(ij,l) * unsaire(ij)
      ENDDO
    ENDDO
!$OMP END DO NOWAIT
  !

END SUBROUTINE divergf_loc
