  SUBROUTINE reevap(klon,klev,iflag_ice_thermo,t_seri,qx, &
             d_t_eva,d_qx_eva)

    ! flag to include modifications to ensure energy conservation (if flag >0)
    USE add_phys_tend_mod, ONLY: fl_cor_ebil
#ifdef ISO
    USE infotrac_phy, ONLY: ntiso,nqtot,ivap,iliq,isol,iqWIsoPha
#ifdef ISOVERIF
    USE isotopes_verif_mod
!, ONLY: errmax,errmaxrel, iso_verif_o18_aberrant_nostop,deltaD,deltaO
    USE isotopes_mod, ONLY: iso_eau,iso_hdo,iso_o18,ridicule
#ifdef ISOTRAC
    USE isotrac_routines_mod, ONLY: iso_verif_traceur_pbidouille
#endif
#endif
#endif
    IMPLICIT none
    !>======================================================================

    INTEGER klon,klev,iflag_ice_thermo
    REAL, DIMENSION(klon,klev), INTENT(in) :: t_seri
    REAL, DIMENSION(klon,klev,nqtot), INTENT(in) ::     qx
    REAL, DIMENSION(klon,klev), INTENT(out) :: d_t_eva
    REAL, DIMENSION(klon,klev,nqtot), INTENT(out) ::        d_qx_eva

    REAL za,zb,zdelta,zlvdcp,zlsdcp
    INTEGER i,k,ixt,ivapcur,iliqcur,isolcur


    !--------Stochastic Boundary Layer Triggering: ALE_BL--------
    !---Propri\'et\'es du thermiques au LCL
    include "YOMCST.h"
    include "YOETHF.h"
    include "FCTTRE.h"
    !IM 100106 BEG : pouvoir sortir les ctes de la physique

DO ixt=1,1+ntiso
    ! Re-evaporer l'eau liquide nuageuse

    iliqcur= iqWIsoPha(ixt,iliq)
    ivapcur= iqWIsoPha(ixt,ivap)
    isolcur= iqWIsoPha(ixt,isol)
!print *,'rrevap ; fl_cor_ebil:',fl_cor_ebil,' iflag_ice_thermo:',iflag_ice_thermo,' RVTMP2',RVTMP2
    DO k = 1, klev  ! re-evaporation de l'eau liquide nuageuse
       DO i = 1, klon

        if (ixt==1) THEN
         if (fl_cor_ebil > 0) THEN
          !zlvdcp=RLVTT/RCPD/(1.0+RVTMP2*(q_seri(i,k)+ql_seri(i,k)+qs_seri(i,k)))
          !zlsdcp=RLSTT/RCPD/(1.0+RVTMP2*(q_seri(i,k)+ql_seri(i,k)+qs_seri(i,k)))
          zlvdcp=RLVTT/RCPD/(1.0+RVTMP2*(qx(i,k,ivapcur)+qx(i,k,iliqcur)+qx(i,k,isolcur)))
          zlsdcp=RLSTT/RCPD/(1.0+RVTMP2*(qx(i,k,ivapcur)+qx(i,k,iliqcur)+qx(i,k,isolcur)))
         else
           zlvdcp=RLVTT/RCPD/(1.0+RVTMP2*qx(i,k,ivapcur))
           !jyg<
           !  Attention : Arnaud a propose des formules completement differentes
           !                  A verifier !!!
           zlsdcp=RLSTT/RCPD/(1.0+RVTMP2*qx(i,k,ivapcur))
         end if
         IF (iflag_ice_thermo == 0) THEN
             zlsdcp=zlvdcp
         ENDIF
          !>jyg
             !CR: on r\'e-\'evapore eau liquide et glace

             !        zdelta = MAX(0.,SIGN(1.,RTT-t_seri(i,k)))
             !        zb = MAX(0.0,ql_seri(i,k))
             !        za = - MAX(0.0,ql_seri(i,k)) &
             !             * (zlvdcp*(1.-zdelta)+zlsdcp*zdelta)
             za = - MAX(0.0,qx(i,k,iliqcur))*zlvdcp &
                  - MAX(0.0,qx(i,k,iliqcur))*zlsdcp
             d_t_eva(i,k) = za

          endif !if (ixt.eq.1) THEN
            !zb = MAX(0.0,ql_seri(i,k)+qs_seri(i,k))
            !d_q_eva(i,k) = zb
            !d_ql_eva(i,k) = -ql_seri(i,k)
            !d_qs_eva(i,k) = -qs_seri(i,k)

            zb = MAX(0.0,qx(i,k,iliqcur)+qx(i,k,isolcur))
            d_qx_eva(i,k,ivapcur) = zb
            d_qx_eva(i,k,iliqcur) = -qx(i,k,iliqcur)
            d_qx_eva(i,k,isolcur) = -qx(i,k,isolcur)


       ENDDO
    ENDDO

    enddo ! do ixt=1,1+niso*(nzone +1)




END SUBROUTINE reevap
