
! $Id: minmaxqfi.F90 5116 2024-07-24 12:54:37Z abarral $

SUBROUTINE minmaxqfi(zq,qmin,qmax,comment)
  USE dimphy
  USE lmdz_print_control, ONLY: prt_level
  IMPLICIT NONE

! Entrees
  REAL,DIMENSION(klon,klev), INTENT(IN)   :: zq
  REAL,INTENT(IN)                         :: qmin,qmax
  CHARACTER(LEN=*),INTENT(IN)             :: comment

! Local  
  INTEGER,DIMENSION(klon)     :: jadrs 
  INTEGER                     :: i, jbad, k

  DO k = 1, klev
     jbad = 0
     DO i = 1, klon
        IF (zq(i,k)>qmax .OR. zq(i,k)<qmin) THEN
           jbad = jbad + 1
           jadrs(jbad) = i
        ENDIF
     ENDDO
     IF (jbad>0) THEN
        WRITE(*,*)comment, "  k = ", k, "jbad > 0"
        if (prt_level >= 1) THEN
           DO i = 1, jbad
              WRITE(*,*) "i,q=", jadrs(i), zq(jadrs(i),k)
           ENDDO
        end if
     ENDIF
  ENDDO
  
END SUBROUTINE minmaxqfi
