

SUBROUTINE SISVAT_wEq( labWEq ,istart)

  ! +------------------------------------------------------------------------+
  ! | MAR          SISVAT_wEq                                22-09-2001  MAR |
  ! |   SubRoutine SISVAT_wEq computes the Snow/Ice  Water  Equivalent       |
  ! |                                                                        |
  ! |                                                                        |
  ! |   Preprocessing  Option: SISVAT IO (not always a standard preprocess.) |
  ! |   ^^^^^^^^^^^^^^^^^^^^^  ^^^^^^^^^                                     |
  ! |   FILE                 |      CONTENT                                  |
  ! |   ~~~~~~~~~~~~~~~~~~~~~+~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ |
  ! | # SISVAT_wEq.ve        | #ve: OUTPUT/Verification: Snow/Ice Water Eqv. |
  ! |                        |      unit 45, SubRoutine  SISVAT_wEq **ONLY** |
  ! +------------------------------------------------------------------------+




  ! +--Global Variables
  ! +  ================

  use VARphy
  use VAR_SV
  use VARxSV

  IMPLICIT NONE



  CHARACTER(LEN=6) :: labWEq
  INTEGER :: istart

  logical :: logWEq
  common/SISVAT_wEq_L/logWEq


  ! +--Local  Variables
  ! +  ================

  INTEGER :: ikl   ,isn
  REAL :: SnoWEQ,IceWEQ


  ! +--Switch Initialization
  ! +  =====================

  IF (.NOT.logWEq)                                              THEN
           logWEq = .TRUE.
           open(unit=45,status='unknown',file='SISVAT_wEq.ve')
           rewind    45
  END IF


  ! +--Snow Water Equivalent
  ! +  =====================

       ikl   = 1
  IF          (isnoSV(ikl)>iiceSV(ikl))                      THEN

      SnoWEQ = 0.
    DO isn   = iiceSV(ikl)+1 ,isnoSV(ikl)
      SnoWEQ = SnoWEQ       + ro__SV(ikl,isn) * dzsnSV(ikl,isn)
    END DO

  END IF


  ! +--Ice  Water Equivalent
  ! +  =====================

  IF        (iiceSV(1)>0)                                    THEN

      IceWEQ = 0.
    DO isn   =             1 ,iiceSV(ikl)
      IceWEQ = IceWEQ       + ro__SV(ikl,isn) * dzsnSV(ikl,isn)
    END DO

  END IF


  ! +--OUTPUT
  ! +  ======

  !!      IF (istart.eq.1)                                              THEN
  !!        WRITE(45,45)dahost,i___SV(lwriSV(1)),j___SV(lwriSV(1)),
  !!     .              n___SV(lwriSV(1))
  !! 45     format(a18,10('-'),'Pt.',3i4,60('-'))
  !!      END IF

  !!      WRITE(45,450) labWEq,IceWEQ,iiceSV(ikl),SnoWEQ
  !!     .                    ,IceWEQ+SnoWEQ,isnoSV(ikl)
  !!     .                                  ,drr_SV(ikl)*dt__SV
  !!     .                                  ,dsn_SV(ikl)*dt__SV
  !!     .                                  ,BufsSV(ikl)
  !! 450  format(a6,3x,'  I+S =',f11.4,'(',i2,') +',f11.4,' =',
  !!     .                       f11.4,'(',i2,')',
  !!     .             '  drr =', f7.4,
  !!     .             '  dsn =', f7.4,
  !!     .             '  Buf =', f7.4)


END SUBROUTINE sisvat_weq
