module Phiw_m

  IMPLICIT NONE

contains

  elemental real function Phiw(zL)

    ! Fonction de stabilit\'e (Monin Obukhov)

    real, intent(in):: zL ! profondeur  / longueur de Monin-Obukhov

    !----------------------------------------------

    if (zL < 0.) THEN
       Phiw = (1. - 16. * zL)**(- 0.5)
    else
       Phiw = 1. + (5. * zL + 4. * zL**2)/(1. + 3. * zL + 0.25 * zL**2)
       ! (Takaya et al. 2010)
    end if

  END FUNCTION Phiw

end module Phiw_m
