module mom_flux_rain_m

  IMPLICIT NONE

contains

  elemental real function mom_flux_rain(u, rain)

    ! Computes momentum flux due to rainfall, in Pa.

    real, intent(in):: U
    ! difference of velocity between air and sea, including gustiness, in m / s

    real, intent(in):: rain ! rain mass flux, in kg m-2 s-1

    !------------------------------------------------------------------------

    mom_flux_rain = 0.85 * U * rain
    ! (Caldwell 1971 k1001, equation (1) and 15 % reduction in speed
    ! as in paragraph 3.a, maybe adequate if u is the wind at 10 m)

  END FUNCTION mom_flux_rain
  
end module mom_flux_rain_m
