SUBROUTINE condsurfs(jour, edgar, flag_dms, &
        lmt_so2h, lmt_so2b, lmt_so2bb, lmt_so2ba, &
        lmt_so2volc, lmt_altvolc, &
        lmt_dmsbio, lmt_h2sbio, lmt_dms, lmt_dmsconc)
  USE dimphy
  USE netcdf, ONLY: nf90_close, nf90_noerr, nf90_inq_varid, nf90_open, &
          nf90_nowrite, nf90_get_var
  IMPLICIT none

  ! Lire les conditions aux limites du modele pour la chimie.
  ! --------------------------------------------------------

  INCLUDE "dimensions.h"

  REAL :: lmt_so2h(klon), lmt_so2b(klon), lmt_so2bb(klon)
  REAL :: lmt_dmsbio(klon), lmt_h2sbio(klon), lmt_so2ba(klon)
  REAL :: lmt_so2volc(klon), lmt_altvolc(klon)
  REAL :: lmt_dms(klon), lmt_dmsconc(klon)
  LOGICAL :: edgar
  INTEGER :: flag_dms

  INTEGER :: jour, i
  INTEGER :: ierr
  INTEGER :: nid, nvarid
  INTEGER :: debut(2), epais(2)

  IF (jour<0 .OR. jour>(360 - 1)) THEN
    IF ((jour>(360 - 1)) .AND. (jour<=367)) THEN
      jour = 360 - 1
      print *, 'JE: jour changed to jour= ', jour
    ELSE
      PRINT*, 'Le jour demande n est pas correcte:', jour
      CALL ABORT
    ENDIF
  ENDIF

  ierr = nf90_open ("limitsoufre.nc", nf90_nowrite, nid)
  if (ierr/=nf90_noerr) THEN
    WRITE(6, *)' Pb d''ouverture du fichier limitsoufre.nc'
    WRITE(6, *)' ierr = ', ierr
    CALL exit(1)
  endif

  ! Tranche a lire:
  debut(1) = 1
  debut(2) = jour + 1
  epais(1) = klon
  epais(2) = 1

  ierr = nf90_inq_varid (nid, "VOLC", nvarid)
  ierr = nf90_get_var(nid, nvarid, lmt_so2volc, debut, epais)
  IF (ierr /= nf90_noerr) THEN
    PRINT*, 'Pb de lecture pour les sources so2 volcan'
    CALL exit(1)
  ENDIF

  ierr = nf90_inq_varid (nid, "ALTI", nvarid)
  ierr = nf90_get_var(nid, nvarid, lmt_altvolc, debut, epais)
  IF (ierr /= nf90_noerr) THEN
    PRINT*, 'Pb de lecture pour les altitudes volcan'
    CALL exit(1)
  ENDIF

  IF (edgar) THEN   !--EDGAR w/o ship and biomass burning

    ierr = nf90_inq_varid (nid, "SO2ED95L", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_so2b, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources so2 edgar low'
      CALL exit(1)
    ENDIF

    ierr = nf90_inq_varid (nid, "SO2ED95H", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_so2h, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources so2 edgar high'
      CALL exit(1)
    ENDIF

  ELSE  !--GEIA

    ierr = nf90_inq_varid (nid, "SO2H", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_so2h, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources so2 haut'
      CALL exit(1)
    ENDIF

    ierr = nf90_inq_varid (nid, "SO2B", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_so2b, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources so2 bas'
      CALL exit(1)
    ENDIF

  ENDIF  !--edgar

  ierr = nf90_inq_varid (nid, "SO2BB", nvarid)
  ierr = nf90_get_var(nid, nvarid, lmt_so2bb, debut, epais)
  IF (ierr /= nf90_noerr) THEN
    PRINT*, 'Pb de lecture pour les sources so2 bb'
    CALL exit(1)
  ENDIF

  ierr = nf90_inq_varid (nid, "SO2BA", nvarid)
  ierr = nf90_get_var(nid, nvarid, lmt_so2ba, debut, epais)
  IF (ierr /= nf90_noerr) THEN
    PRINT*, 'Pb de lecture pour les sources so2 bateau'
    CALL exit(1)
  ENDIF

  ierr = nf90_inq_varid (nid, "DMSB", nvarid)
  ierr = nf90_get_var(nid, nvarid, lmt_dmsbio, debut, epais)
  IF (ierr /= nf90_noerr) THEN
    PRINT*, 'Pb de lecture pour les sources dms bio'
    CALL exit(1)
  ENDIF

  ierr = nf90_inq_varid (nid, "H2SB", nvarid)
  ierr = nf90_get_var(nid, nvarid, lmt_h2sbio, debut, epais)
  IF (ierr /= nf90_noerr) THEN
    PRINT*, 'Pb de lecture pour les sources h2s bio'
    CALL exit(1)
  ENDIF

  IF (flag_dms==1) THEN

    ierr = nf90_inq_varid (nid, "DMSL", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_dms, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources dms liss'
      CALL exit(1)
    ENDIF

  ELSEIF (flag_dms==2) THEN

    ierr = nf90_inq_varid (nid, "DMSW", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_dms, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources dms wann'
      CALL exit(1)
    ENDIF

  ELSEIF (flag_dms==3) THEN

    ierr = nf90_inq_varid (nid, "DMSC1", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_dmsconc, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources dmsconc old'
      CALL exit(1)
    ENDIF

  ELSEIF (flag_dms==4) THEN

    ierr = nf90_inq_varid (nid, "DMSC2", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_dmsconc, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources dms conc 2'
      CALL exit(1)
    ENDIF

  ELSEIF (flag_dms==5) THEN

    ierr = nf90_inq_varid (nid, "DMSC3", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_dmsconc, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources dms conc 3'
      CALL exit(1)
    ENDIF

  ELSEIF (flag_dms==6) THEN

    ierr = nf90_inq_varid (nid, "DMSC4", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_dmsconc, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources dms conc 4'
      CALL exit(1)
    ENDIF

  ELSEIF (flag_dms==7) THEN

    ierr = nf90_inq_varid (nid, "DMSC5", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_dmsconc, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources dms conc 5'
      CALL exit(1)
    ENDIF

  ELSEIF (flag_dms==8) THEN

    ierr = nf90_inq_varid (nid, "DMSC6", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_dmsconc, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources dms conc 6'
      CALL exit(1)
    ENDIF

  ELSEIF (flag_dms==9) THEN

    ierr = nf90_inq_varid (nid, "DMSC7", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_dmsconc, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources dms conc 7'
      CALL exit(1)
    ENDIF

  ELSEIF (flag_dms==10) THEN

    ierr = nf90_inq_varid (nid, "DMSC8", nvarid)
    ierr = nf90_get_var(nid, nvarid, lmt_dmsconc, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources dms conc 8'
      CALL exit(1)
    ENDIF

  ELSE

    PRINT *, 'choix non possible pour flag_dms'
    STOP

  ENDIF

  ierr = nf90_close(nid)

  IF (flag_dms<=2) THEN
    DO i = 1, klon
      lmt_dmsconc(i) = 0.0
    ENDDO
  ELSE
    DO i = 1, klon
      lmt_dms(i) = 0.0
    ENDDO
  ENDIF

  PRINT*, 'Sources SOUFRE lues pour jour: ', jour


END SUBROUTINE condsurfs
