SUBROUTINE condsurfc_new(jour, lmt_bcff, lmt_bcnff, &
        lmt_bcbbl, lmt_bcbbh, lmt_bcba, &
        lmt_omff, lmt_omnff, lmt_ombbl, lmt_ombbh, &
        lmt_omnat, lmt_omba)
  USE lmdz_grid_phy
  USE lmdz_phys_para
  USE dimphy
  USE netcdf, ONLY: nf90_get_var, nf90_close, nf90_noerr, nf90_inq_varid, nf90_open, nf90_nowrite
  IMPLICIT none

  ! Lire les conditions aux limites du modele pour la chimie.
  ! --------------------------------------------------------

  INCLUDE "dimensions.h"

  REAL :: lmt_bcff(klon), lmt_bcnff(klon), lmt_bcba(klon)
  REAL :: lmt_omff(klon), lmt_omnff(klon), lmt_ombb(klon)
  REAL :: lmt_bcbbl(klon), lmt_bcbbh(klon)
  REAL :: lmt_ombbl(klon), lmt_ombbh(klon)
  REAL :: lmt_omnat(klon), lmt_omba(klon)
  REAL :: lmt_terp(klon)

  REAL :: lmt_bcff_glo(klon_glo), lmt_bcnff_glo(klon_glo)
  REAL :: lmt_bcba_glo(klon_glo)
  REAL :: lmt_omff_glo(klon_glo), lmt_omnff_glo(klon_glo)
  REAL :: lmt_ombb_glo(klon_glo)
  REAL :: lmt_bcbbl_glo(klon_glo), lmt_bcbbh_glo(klon_glo)
  REAL :: lmt_ombbl_glo(klon_glo), lmt_ombbh_glo(klon_glo)
  REAL :: lmt_omnat_glo(klon_glo), lmt_omba_glo(klon_glo)
  REAL :: lmt_terp_glo(klon_glo)

  INTEGER :: jour, i
  INTEGER :: ierr
  INTEGER :: nid1, nvarid
  INTEGER :: debut(2), epais(2)

  !  IF (jour.LT.0 .OR. jour.GT.(366-1)) THEN
  IF (jour<0 .OR. jour>366) THEN
    PRINT*, 'Le jour demande n est pas correcte:', jour
    print *, 'JE: FORCED TO CONTINUE (emissions have&
            & to be longer than 1 year!!!! )'
    !JE         CALL ABORT
  ENDIF

  !$OMP MASTER
  IF (is_mpi_root .AND. is_omp_root) THEN

    ! Tranche a lire:
    debut(1) = 1
    debut(2) = jour
    epais(1) = klon_glo
    ! epais(1) = klon
    epais(2) = 1

    !=======================================================================
    !                    BC EMISSIONS
    !=======================================================================

    ierr = nf90_open ("carbon_emissions.nc", nf90_nowrite, nid1)
    if (ierr/=nf90_noerr) THEN
      WRITE(6, *)' Pb d''ouverture du fichier limitbc.nc'
      WRITE(6, *)' ierr = ', ierr
      CALL exit(1)
    endif

    ! BC emissions from fossil fuel combustion

    ierr = nf90_inq_varid (nid1, "BCFF", nvarid)
    ierr = nf90_get_var (nid1, nvarid, lmt_bcff_glo, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources BC'
      CALL exit(1)
    ENDIF
    !print *,'lmt_bcff = ',lmt_bcff
    !stop

    ! BC emissions from non fossil fuel combustion

    ierr = nf90_inq_varid (nid1, "BCNFF", nvarid)
    ierr = nf90_get_var (nid1, nvarid, lmt_bcnff_glo, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources BC'
      CALL exit(1)
    ENDIF

    ! Low BC emissions from biomass burning

    ierr = nf90_inq_varid (nid1, "BCBBL", nvarid)
    ierr = nf90_get_var (nid1, nvarid, lmt_bcbbl_glo, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources BC low'
      CALL exit(1)
    ENDIF

    ! High BC emissions from biomass burning

    ierr = nf90_inq_varid (nid1, "BCBBH", nvarid)
    ierr = nf90_get_var (nid1, nvarid, lmt_bcbbh_glo, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources BC high'
      CALL exit(1)
    ENDIF

    ! BC emissions from ship transport

    ierr = nf90_inq_varid (nid1, "BCBA", nvarid)
    ierr = nf90_get_var (nid1, nvarid, lmt_bcba_glo, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources BC'
      CALL exit(1)
    ENDIF

    !=======================================================================
    ! OM EMISSIONS
    !=======================================================================

    ! OM emissions from fossil fuel combustion

    ierr = nf90_inq_varid (nid1, "OMFF", nvarid)
    ierr = nf90_get_var (nid1, nvarid, lmt_omff_glo, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources OM'
      CALL exit(1)
    ENDIF

    ! OM emissions from non fossil fuel combustion

    ierr = nf90_inq_varid (nid1, "OMNFF", nvarid)
    ierr = nf90_get_var (nid1, nvarid, lmt_omnff_glo, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources OM'
      CALL exit(1)
    ENDIF

    ! Low OM emissions from biomass burning - low

    ierr = nf90_inq_varid (nid1, "OMBBL", nvarid)
    ierr = nf90_get_var (nid1, nvarid, lmt_ombbl_glo, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources OM low'
      CALL exit(1)
    ENDIF

    ! High OM emissions from biomass burning - high

    ierr = nf90_inq_varid (nid1, "OMBBH", nvarid)
    ierr = nf90_get_var (nid1, nvarid, lmt_ombbh_glo, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources OM high'
      CALL exit(1)
    ENDIF

    ! High OM emissions from ship

    ierr = nf90_inq_varid (nid1, "OMBA", nvarid)
    ierr = nf90_get_var (nid1, nvarid, lmt_omba_glo, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources OM ship'
      CALL exit(1)
    ENDIF

    ! Natural Terpene emissions => Natural OM emissions

    ierr = nf90_inq_varid (nid1, "TERP", nvarid)
    ierr = nf90_get_var (nid1, nvarid, lmt_terp_glo, debut, epais)
    IF (ierr /= nf90_noerr) THEN
      PRINT*, 'Pb de lecture pour les sources Terpene'
      CALL exit(1)
    ENDIF

    DO i = 1, klon_glo
      lmt_omnat_glo(i) = lmt_terp_glo(i) * 0.11 * 1.4 !-- 11% Terpene is OC
    ENDDO

    ierr = nf90_close(nid1)

    PRINT*, 'Carbon sources lues pour jour: ', jour
    ! lmt_bcff(klon)=0.0
    ! lmt_bcnff(klon)=0.0
    ! lmt_omff(klon)=0.0
    ! lmt_omnff(klon)=0.0
    ! lmt_ombb(klon)=0.0
    ! lmt_bcbbl(klon)=0.0
    ! lmt_bcbbh(klon)=0.0
    ! lmt_ombbl(klon)=0.0
    ! lmt_ombbh(klon)=0.0
    ! lmt_omnat(klon)=0.0
    ! lmt_omba(klon)=0.0
    ! lmt_terp(klon)=0.0

  ENDIF
  !$OMP END MASTER
  !$OMP BARRIER
  CALL scatter(lmt_bcff_glo, lmt_bcff)
  CALL scatter(lmt_bcnff_glo, lmt_bcnff)
  CALL scatter(lmt_bcbbl_glo, lmt_bcbbl)
  CALL scatter(lmt_bcbbh_glo, lmt_bcbbh)
  CALL scatter(lmt_bcba_glo, lmt_bcba)
  CALL scatter(lmt_omff_glo, lmt_omff)
  CALL scatter(lmt_omnff_glo, lmt_omnff)
  CALL scatter(lmt_ombbl_glo, lmt_ombbl)
  CALL scatter(lmt_ombbh_glo, lmt_ombbh)
  CALL scatter(lmt_omba_glo, lmt_omba)
  CALL scatter(lmt_terp_glo, lmt_terp)
  CALL scatter(lmt_omnat_glo, lmt_omnat)


END SUBROUTINE condsurfc_new
