MODULE lmdz_abort_physic
  IMPLICIT NONE; PRIVATE
  PUBLIC abort_physic
CONTAINS

  SUBROUTINE abort_physic(modname, message, ierr)

    USE IOIPSL
    USE lmdz_phys_para
    USE lmdz_print_control, ONLY: lunout
    IMPLICIT NONE

    ! Stops the simulation cleanly, closing files and printing various
    ! comments

    !  Input: modname = name of calling program
    !         message = stuff to print
    !         ierr    = severity of situation ( = 0 normal )

    CHARACTER(LEN = *), intent(in) :: modname
    integer ierr, ierror_mpi
    CHARACTER(LEN = *), intent(in) :: message

    WRITE(lunout, *) 'in abort_physic'
    !$OMP MASTER
    CALL histclo
    CALL restclo
    if (mpi_rank == 0) THEN
      CALL getin_dump
    endif
    !$OMP END MASTER

    WRITE(lunout, *) 'Stopping in ', modname
    WRITE(lunout, *) 'Reason = ', message
    if (ierr == 0) THEN
      WRITE(lunout, *) 'Everything is cool'
      if (using_mpi) THEN
        !$OMP CRITICAL (MPI_ABORT_PHYSIC)
        CALL MPI_ABORT(COMM_LMDZ_PHY, 0, ierror_mpi)
        !$OMP END CRITICAL (MPI_ABORT_PHYSIC)
      else
        stop 0
      endif
    else
      WRITE(lunout, *) 'Houston, we have a problem, ierr = ', ierr
      if (using_mpi) THEN
        !$OMP CRITICAL (MPI_ABORT_PHYSIC)
        CALL MPI_ABORT(COMM_LMDZ_PHY, 1, ierror_mpi)
        !$OMP END CRITICAL (MPI_ABORT_PHYSIC)
      else
        stop 1
      endif
    endif
  END

END MODULE lmdz_abort_physic