! Library for misc. useful math functions

MODULE lmdz_libmath
  IMPLICIT NONE; PRIVATE
  PUBLIC ismin, ismax

CONTAINS

  function ismax(n, sx, incx)
    INTEGER :: n, i, incx, ismax, ix
    REAL :: sx((n - 1) * incx + 1), sxmax

    ix = 1
    ismax = 1
    sxmax = sx(1)
    do i = 1, n - 1
      ix = ix + incx
      IF(sx(ix)>sxmax) THEN
        sxmax = sx(ix)
        ismax = i + 1
      endif
    END DO
  END FUNCTION ismax


  FUNCTION ismin(n, sx, incx)
    INTEGER :: n, i, incx, ismin, ix
    REAL :: sx((n - 1) * incx + 1), sxmin
    !
    ix = 1
    ismin = 1
    sxmin = sx(1)
    DO i = 1, n - 1
      ix = ix + incx
      IF(sx(ix)<sxmin) THEN
        sxmin = sx(ix)
        ismin = i + 1
      endif
    ENDDO
  END FUNCTION ismin

  SUBROUTINE minmax(imax, xi, zmin, zmax)
    !
    !  P. Le Van

    INTEGER :: imax
    REAL :: xi(imax)
    REAL :: zmin, zmax
    INTEGER :: i

    zmin = xi(1)
    zmax = xi(1)

    DO i = 2, imax
      zmin = MIN(zmin, xi(i))
      zmax = MAX(zmax, xi(i))
    ENDDO

  END SUBROUTINE minmax

END MODULE lmdz_libmath
