MODULE lmdz_formcoord
  IMPLICIT NONE; PRIVATE
  PUBLIC formcoord
CONTAINS

  SUBROUTINE formcoord(unit, n, x, a, rev, text)
    IMPLICIT NONE
    INTEGER :: n, unit, ndec
    logical :: rev
    REAL :: x(n), a
    CHARACTER(LEN = 4) :: text

    INTEGER :: i, id, i1, i2, in
    REAL :: dx, dxmin

    IF(rev) THEN
      id = -1
      i1 = n
      i2 = n - 1
      in = 1
      WRITE(unit, 3000) text(1:1)
    else
      id = 1
      i1 = 1
      i2 = 2
      in = n
    endif

    if (n<2) THEN
      ndec = 1
      WRITE(unit, 1000) text, n, x(1) * a
    else
      dxmin = abs(x(2) - x(1))
      do i = 2, n - 1
        dx = abs(x(i + 1) - x(i))
        if (dx<dxmin) dxmin = dx
      enddo

      ndec = -log10(dxmin) + 2
      IF(mod(n, 6)==1) THEN
        WRITE(unit, 1000) text, n, x(i1) * a
        WRITE(unit, 2000) (x(i) * a, i=i2, in, id)
      else
        WRITE(unit, 1000) text, n
        WRITE(unit, 2000) (x(i) * a, i=i1, in, id)
      endif
    endif

    1000   format(a4, 2x, i4, ' LEVELS', 43x, f12.2)
    2000   format(6f12.2)
    3000   format('FORMAT ', a1, 'REV')

  END SUBROUTINE formcoord
END MODULE lmdz_formcoord
